/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.mongo;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import io.corbel.lib.mongo.SafeKeys;
import io.corbel.lib.mongo.utils.GsonUtil;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;

public class JsonObjectMongoWriteConverter
implements Converter<JsonElement, DBObject> {
    private static final String JSON_DECIMAL_SEPARATOR = ".";

    public DBObject convert(JsonElement source) {
        if (source == null || source.isJsonNull()) {
            return null;
        }
        if (source.isJsonObject()) {
            return this.convert((JsonObject)source);
        }
        return this.convert((JsonArray)source);
    }

    private DBObject convert(JsonObject source) {
        BasicDBObject object = new BasicDBObject();
        for (Map.Entry entry : source.entrySet()) {
            String key = SafeKeys.getSafeKey((String)entry.getKey());
            if (((JsonElement)entry.getValue()).isJsonObject()) {
                object.put(key, (Object)this.convert(((JsonElement)entry.getValue()).getAsJsonObject()));
                continue;
            }
            if (((JsonElement)entry.getValue()).isJsonArray()) {
                object.put(key, (Object)this.convert(((JsonElement)entry.getValue()).getAsJsonArray()));
                continue;
            }
            if (!((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
            object.put(key, GsonUtil.getPrimitive(this.parseJsonPrimitive((JsonElement)entry.getValue())));
        }
        return object;
    }

    private DBObject convert(JsonArray array) {
        BasicDBList list = new BasicDBList();
        for (JsonElement element : array) {
            if (element.isJsonArray()) {
                list.add((Object)this.convert(element.getAsJsonArray()));
                continue;
            }
            if (element.isJsonObject()) {
                list.add((Object)this.convert(element.getAsJsonObject()));
                continue;
            }
            if (!element.isJsonPrimitive()) continue;
            list.add(GsonUtil.getPrimitive(this.parseJsonPrimitive(element)));
        }
        return list;
    }

    private JsonPrimitive parseJsonPrimitive(JsonElement primitive) {
        return this.convertIfLazilyParsedNumber(primitive.getAsJsonPrimitive());
    }

    private JsonPrimitive convertIfLazilyParsedNumber(JsonPrimitive primitive) {
        Number number;
        if (primitive.isNumber() && (number = primitive.getAsNumber()) instanceof LazilyParsedNumber) {
            number = number.toString().contains(JSON_DECIMAL_SEPARATOR) ? (Number)number.doubleValue() : (Number)number.longValue();
            primitive = new JsonPrimitive(number);
        }
        return primitive;
    }
}

