/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.mongo;

import java.time.Duration;
import java.time.Period;
import java.time.temporal.TemporalAmount;
import org.springframework.core.convert.converter.Converter;

public class TemporalAmountToStringConverter
implements Converter<TemporalAmount, String> {
    private static final String ZERO_YEARS_MONTHS_AND_DAYS_PATTERN = "00Y00M00D";
    private static final String ZERO_HOURS_MINUTES_AND_SECONDS_PATTERN = "00H00M00S";
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_MINUTE = 60L;

    public String convert(TemporalAmount temporalAmount) {
        if (temporalAmount != null) {
            if (temporalAmount instanceof Period) {
                Period period = ((Period)temporalAmount).normalized();
                return "P" + this.normalizeString(period.getYears()) + "Y" + this.normalizeString(period.getMonths()) + "M" + this.normalizeString(period.getDays()) + "D" + "T" + ZERO_HOURS_MINUTES_AND_SECONDS_PATTERN;
            }
            return this.convertDurationToString((Duration)temporalAmount);
        }
        return null;
    }

    private String normalizeString(int amount) {
        return this.normalizeString(String.valueOf(amount));
    }

    private String normalizeString(String result) {
        if (result.length() == 1) {
            result = "0" + result;
        }
        return result;
    }

    private String convertDurationToString(Duration duration) {
        long hours = duration.getSeconds() / 3600L;
        int minutes = (int)(duration.getSeconds() % 3600L / 60L);
        int seconds = (int)(duration.getSeconds() % 60L);
        return "P" + ZERO_YEARS_MONTHS_AND_DAYS_PATTERN + "T" + String.valueOf(hours) + "H" + this.normalizeString(minutes) + "M" + this.normalizeString(seconds) + "S";
    }
}

