/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.mongo.config;

import com.google.common.base.Joiner;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ReadPreference;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.config.AbstractMongoConfiguration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.WriteResultChecking;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.util.StringUtils;

@Configuration
public abstract class DefaultMongoConfiguration
extends AbstractMongoConfiguration {
    @Bean
    public MongoClient mongo() throws Exception {
        if (this.getMongoProperty("mongodb.replicaset", String.class) != null) {
            return new MongoClient(this.getMongoReplicaset(), this.getMongoCredentials(), this.getMongoOptions());
        }
        if (this.getMongoProperty("mongodb.host", String.class) != null) {
            return new MongoClient(new ServerAddress(this.getMongoProperty("mongodb.host", String.class), this.getMongoProperty("mongodb.port", Integer.class, 27017).intValue()), this.getMongoCredentials(), this.getMongoOptions());
        }
        throw new IllegalArgumentException("Missing mongodb host or replicaset configuration");
    }

    private List<ServerAddress> getMongoReplicaset() throws UnknownHostException {
        String replicasetConfig = this.getMongoProperty("mongodb.replicaset", String.class);
        if (replicasetConfig == null) {
            return null;
        }
        String[] servers = replicasetConfig.split(",");
        ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>(servers.length);
        for (String server : servers) {
            String[] hostAndPort = server.trim().split(":");
            try {
                serverAddresses.add(new ServerAddress(hostAndPort[0], Integer.parseInt(hostAndPort[1])));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid port for server " + hostAndPort[0], e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("Missing port for server" + hostAndPort[1], e);
            }
        }
        return serverAddresses;
    }

    public MappingMongoConverter mappingMongoConverter() throws Exception {
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)new DefaultDbRefResolver(this.mongoDbFactory()), (MappingContext)this.mongoMappingContext());
        converter.setTypeMapper((MongoTypeMapper)this.mongoTypeMapper());
        converter.setCustomConversions(this.customConversions());
        return converter;
    }

    protected DefaultMongoTypeMapper mongoTypeMapper() {
        return new DefaultMongoTypeMapper(null);
    }

    @Bean
    public List<MongoCredential> getMongoCredentials() {
        ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>();
        String user = this.getMongoProperty("mongodb.username", String.class);
        String password = this.getMongoProperty("mongodb.password", String.class);
        String authDatabase = this.getMongoProperty("mongodb.authenticationDatabase", String.class, "admin");
        if (StringUtils.hasLength((String)user) && StringUtils.hasLength((String)password)) {
            credentials.add(MongoCredential.createMongoCRCredential((String)user, (String)authDatabase, (char[])password.toCharArray()));
        }
        return credentials;
    }

    @Bean
    public MongoClientOptions getMongoOptions() {
        MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder();
        optionsBuilder.autoConnectRetry(this.getMongoProperty("mongodb.autoConnectRetry", Boolean.class).booleanValue());
        optionsBuilder.connectionsPerHost(this.getMongoProperty("mongodb.connectionsPerHost", Integer.class).intValue());
        optionsBuilder.connectTimeout(this.getMongoProperty("mongodb.connectTimeout", Integer.class).intValue());
        optionsBuilder.cursorFinalizerEnabled(this.getMongoProperty("mongodb.cursorFinalizerEnabled", Boolean.class).booleanValue());
        optionsBuilder.writeConcern(this.getWriteConcern());
        optionsBuilder.maxAutoConnectRetryTime(this.getMongoProperty("mongodb.maxAutoConnectRetryTime", Long.class).longValue());
        optionsBuilder.maxWaitTime(this.getMongoProperty("mongodb.maxWaitTime", Integer.class).intValue());
        optionsBuilder.socketKeepAlive(this.getMongoProperty("mongodb.socketKeepAlive", Boolean.class).booleanValue());
        optionsBuilder.socketTimeout(this.getMongoProperty("mongodb.socketTimeout", Integer.class).intValue());
        optionsBuilder.threadsAllowedToBlockForConnectionMultiplier(this.getMongoProperty("mongodb.threadsAllowedToBlockForConnectionMultiplier", Integer.class).intValue());
        if (this.getMongoProperty("mongodb.slaveOk", Boolean.class).booleanValue()) {
            optionsBuilder.readPreference(ReadPreference.secondaryPreferred());
        }
        return optionsBuilder.build();
    }

    public WriteConcern getWriteConcern() {
        Boolean fsync = this.getMongoProperty("mongodb.fsync", Boolean.class);
        Boolean j = this.getMongoProperty("mongodb.j", Boolean.class);
        Integer w = this.getMongoProperty("mongodb.w", Integer.class);
        if (w == null) {
            w = 1;
        }
        Integer wtimeout = this.getMongoProperty("mongodb.wtimeout", Integer.class);
        return new WriteConcern(w.intValue(), wtimeout.intValue(), fsync.booleanValue(), j.booleanValue());
    }

    @Bean
    public MongoTemplate mongoTemplate() throws Exception {
        MongoTemplate template = super.mongoTemplate();
        template.setWriteResultChecking(this.getWriteResultChecking());
        return template;
    }

    private <E> E getMongoProperty(String property, Class<E> type) {
        return this.getMongoProperty(property, type, null);
    }

    private <E> E getMongoProperty(String property, Class<E> type, E def) {
        Object value = this.getEnvironment().getProperty(Joiner.on((String)".").join((Object[])new String[]{this.getMongoConfigurationPrefix(), property}), type);
        return (E)(value == null ? def : value);
    }

    protected WriteResultChecking getWriteResultChecking() {
        return WriteResultChecking.EXCEPTION;
    }

    protected abstract Environment getEnvironment();

    protected String getMongoConfigurationPrefix() {
        return this.getDatabaseName();
    }
}

