/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.mongo.index;

import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.TextIndexDefinition;

public class MongoTextSearchIndex {
    private final TextIndexDefinition.TextIndexDefinitionBuilder index = new TextIndexDefinition.TextIndexDefinitionBuilder();

    public MongoTextSearchIndex named(String name) {
        this.index.named(name);
        return this;
    }

    public MongoTextSearchIndex on(String ... key) {
        this.index.onFields(key);
        return this;
    }

    public MongoTextSearchIndex on(String key, float weight) {
        this.index.onField(key, Float.valueOf(weight));
        return this;
    }

    public MongoTextSearchIndex onAllFields() {
        this.index.onAllFields();
        return this;
    }

    public MongoTextSearchIndex defaultLanguage(String language) {
        this.index.withDefaultLanguage(language);
        return this;
    }

    public MongoTextSearchIndex withLanguageOverride(String language) {
        this.index.withLanguageOverride(language);
        return this;
    }

    public IndexDefinition getIndexDefinition() {
        return this.index.build();
    }
}

