/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/version")
@Produces(value={"application/json"})
public class VersionResource {
    private static final Logger LOG = LoggerFactory.getLogger(VersionResource.class);
    protected static final String DEFAULT_BUILD_METADATA_FILE = "/META-INF/build.properties";
    private final String[] propertyFiles;
    private Properties buildMetadataProperties;

    public VersionResource(String ... buildMetadataFiles) {
        this.propertyFiles = buildMetadataFiles;
    }

    public VersionResource() {
        this(DEFAULT_BUILD_METADATA_FILE);
    }

    @GET
    public Response getVersion() {
        Properties data = this.getBuildMetadataProperties();
        if (data == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().entity((Object)data).build();
    }

    private Properties getBuildMetadataProperties() {
        if (this.buildMetadataProperties == null) {
            this.loadBuildMetadataProperties();
        }
        return this.buildMetadataProperties;
    }

    private void loadBuildMetadataProperties() {
        LOG.info("loading build metadata file {} from classpath", (Object[])this.propertyFiles);
        for (String propertyFile : this.propertyFiles) {
            InputStream buildPropertiesStream = VersionResource.class.getResourceAsStream(propertyFile);
            if (buildPropertiesStream == null) continue;
            Properties prop = new Properties();
            try {
                prop.load(buildPropertiesStream);
            }
            catch (IOException e) {
                LOG.warn("Problem loading metadata file: " + propertyFile, (Throwable)e);
            }
            this.buildMetadataProperties = prop;
            return;
        }
        LOG.info("Build metadata file {} not found", (Object[])this.propertyFiles);
    }
}

