/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.auth;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.corbel.lib.ws.api.error.ErrorResponseFactory;
import io.corbel.lib.ws.auth.AuthorizationInfo;
import io.corbel.lib.ws.auth.CookieOAuthFactory;
import io.corbel.lib.ws.auth.PublicAccessService;
import io.dropwizard.auth.AuthFactory;
import io.dropwizard.auth.oauth.OAuthFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.eclipse.jetty.http.HttpHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=2000)
public class AuthorizationRequestFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationRequestFilter.class);
    public static final String AUTHORIZATION_INFO_PROPERTIES_KEY = "AuthorizationInfo";
    private static final String VERSION_REGEX = "v[0-9]+\\.[0-9]+/";
    private static final String EMPTY_STRING = "";
    private final OAuthFactory<AuthorizationInfo> oAuthProvider;
    private final CookieOAuthFactory<AuthorizationInfo> cookieOAuthProvider;
    private final PublicAccessService publicAccessService;
    private final String unAuthenticatedPathPattern;
    private final boolean checkDomain;
    private final Pattern requestWithDomainPattern;
    @Context
    private HttpServletRequest request;

    public AuthorizationRequestFilter(OAuthFactory<AuthorizationInfo> provider, CookieOAuthFactory<AuthorizationInfo> cookieOAuthProvider, PublicAccessService publicAccessService, String unAuthenticatedPathPattern, boolean checkDomain, String endpoints) {
        this.oAuthProvider = provider;
        this.cookieOAuthProvider = cookieOAuthProvider;
        this.publicAccessService = publicAccessService;
        this.unAuthenticatedPathPattern = unAuthenticatedPathPattern;
        this.checkDomain = checkDomain;
        this.requestWithDomainPattern = Pattern.compile("v[0-9]+\\.[0-9]+/[\\w\\-:\\.]+/(" + endpoints.replace(",", "|") + ")(/.*)?");
    }

    public AuthorizationRequestFilter(OAuthFactory<AuthorizationInfo> provider, CookieOAuthFactory<AuthorizationInfo> cookieOAuthProvider, String unAuthenticatedPathPattern, boolean checkDomain, String endpoints) {
        this(provider, cookieOAuthProvider, null, unAuthenticatedPathPattern, checkDomain, endpoints);
    }

    public AuthorizationRequestFilter() {
        this.oAuthProvider = null;
        this.cookieOAuthProvider = null;
        this.publicAccessService = null;
        this.unAuthenticatedPathPattern = null;
        this.checkDomain = false;
        this.requestWithDomainPattern = null;
    }

    public void filter(ContainerRequestContext request) {
        if (!request.getUriInfo().getPath().matches(this.unAuthenticatedPathPattern) && !request.getMethod().equals("OPTIONS")) {
            CustomRequest customRequest = new CustomRequest(this.getRequest(), request);
            AuthFactory localOAuthProvider = this.oAuthProvider.clone(false);
            localOAuthProvider.setRequest((HttpServletRequest)customRequest);
            AuthorizationInfo info = (AuthorizationInfo)localOAuthProvider.provide();
            if (info == null) {
                AuthFactory<String, AuthorizationInfo> localCookieOAuthProvider = this.cookieOAuthProvider.clone(false);
                localCookieOAuthProvider.setRequest((HttpServletRequest)customRequest);
                info = (AuthorizationInfo)localCookieOAuthProvider.provide();
            }
            String domainId = this.getDomainId(info, request);
            if (info != null) {
                if (this.checkDomain && !this.isEqualsOrChildDomain(info.getDomainId(), domainId)) {
                    throw new WebApplicationException(this.generateUnauthorizedTokenResponse());
                }
                this.checkTokenAccessRules(info, request, domainId);
                this.storeAuthorizationInfoInRequestProperties(info, request);
            } else {
                this.checkPublicAccessRules(domainId, request);
            }
        }
    }

    private boolean isEqualsOrChildDomain(String tokenDomainId, String urlDomainId) {
        return tokenDomainId.equals(urlDomainId) || tokenDomainId.startsWith(urlDomainId + ":") || urlDomainId.startsWith(tokenDomainId + ":");
    }

    private String getDomainId(AuthorizationInfo info, ContainerRequestContext request) {
        if (this.requestWithDomainPattern.matcher(request.getUriInfo().getPath()).matches()) {
            return request.getUriInfo().getPath().split("/")[1];
        }
        return info != null ? info.getDomainId() : null;
    }

    public void checkTokenAccessRules(AuthorizationInfo info, ContainerRequestContext request, String domainId) {
        Set<JsonObject> applicableRules = this.getApplicableAccessRules(info.getAccessRules(), request, domainId, info.getUserId() != null);
        if (applicableRules.isEmpty() && this.getApplicablePublicAccessRules(domainId, request).isEmpty()) {
            throw new WebApplicationException(this.generateUnauthorizedTokenResponse());
        }
    }

    public void checkPublicAccessRules(String domainId, ContainerRequestContext request) {
        Set<JsonObject> applicableRules = this.getApplicablePublicAccessRules(domainId, request);
        if (applicableRules.isEmpty()) {
            throw new WebApplicationException(this.generateInvalidTokenResponse());
        }
    }

    private Set<JsonObject> getApplicableAccessRules(Set<JsonObject> accessRules, ContainerRequestContext request, String domainId, boolean userToken) {
        String scopeUrl = this.extractScopeUrl(domainId, request.getUriInfo().getPath());
        return Sets.filter(accessRules, rule -> this.matchesMethod(request.getMethod(), (JsonObject)rule) && this.matchesUriPath(scopeUrl, (JsonObject)rule) && this.matchesMediaTypes(request, (JsonObject)rule) && this.matchesTokenType(userToken, (JsonObject)rule));
    }

    private Set<JsonObject> getApplicablePublicAccessRules(String domainId, ContainerRequestContext request) {
        Set<JsonObject> applicableRules = null;
        if (this.publicAccessService != null) {
            Set<JsonObject> accessRules = this.publicAccessService.getDomainPublicRules(domainId);
            applicableRules = this.getApplicableAccessRules(accessRules, request, domainId, false);
        }
        return applicableRules != null ? applicableRules : Collections.EMPTY_SET;
    }

    private Response generateInvalidTokenResponse() {
        return ErrorResponseFactory.getInstance().unauthorized("invalid_token", "The authorization token is invalid");
    }

    private Response generateUnauthorizedTokenResponse() {
        return ErrorResponseFactory.getInstance().unauthorized("unauthorized_token", "The authorization token can not perform the request");
    }

    private String extractScopeUrl(String domainId, String path) {
        String regex = domainId != null ? "v[0-9]+\\.[0-9]+/(" + domainId + "/)?" : VERSION_REGEX;
        return path.replaceFirst(regex, EMPTY_STRING);
    }

    private void storeAuthorizationInfoInRequestProperties(AuthorizationInfo info, ContainerRequestContext request) {
        request.setProperty(AUTHORIZATION_INFO_PROPERTIES_KEY, (Object)info);
    }

    private boolean matchesTokenType(boolean userToken, JsonObject rule) {
        String value;
        if (!rule.has("tokenType")) {
            return true;
        }
        switch (value = rule.get("tokenType").getAsString()) {
            case "user": {
                return userToken;
            }
        }
        return false;
    }

    private boolean matchesMethod(String method, JsonObject input) {
        if (!input.has("methods")) {
            LOG.warn("Http access rule without methods field: {}", (Object)input.toString());
            return false;
        }
        JsonArray methods = input.get("methods").getAsJsonArray();
        for (JsonElement jsonMethod : methods) {
            if (!method.equals(jsonMethod.getAsString())) continue;
            return true;
        }
        return false;
    }

    private boolean matchesMediaTypes(ContainerRequestContext request, JsonObject input) {
        if (!input.has("mediaTypes")) {
            LOG.warn("Http access rule without mediaTypes field: {}", (Object)input.toString());
            return false;
        }
        JsonArray mediaTypesArray = input.get("mediaTypes").getAsJsonArray();
        for (MediaType mediaType : request.getAcceptableMediaTypes()) {
            if (!StreamSupport.stream(mediaTypesArray.spliterator(), true).map(mediaTypeElement -> MediaType.valueOf((String)mediaTypeElement.getAsString())).anyMatch(arg_0 -> ((MediaType)mediaType).isCompatible(arg_0))) continue;
            return true;
        }
        return false;
    }

    private boolean matchesUriPath(String path, JsonObject input) {
        if (!input.has("uri")) {
            LOG.warn("Http access rule without uri field: {}", (Object)input.toString());
            return false;
        }
        return path.matches(input.get("uri").getAsString());
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public class CustomRequest
    implements HttpServletRequest {
        private final HttpServletRequest request;
        private final ContainerRequestContext requestContext;

        public CustomRequest(HttpServletRequest request, ContainerRequestContext requestContext) {
            this.request = request;
            this.requestContext = requestContext;
        }

        public Object getAttribute(String name) {
            return this.request.getAttribute(name);
        }

        public String getHeader(String name) {
            if (HttpHeader.AUTHORIZATION.is(name)) {
                return this.requestContext.getHeaderString(name);
            }
            return this.request.getHeader(name);
        }

        public String getAuthType() {
            return this.request.getAuthType();
        }

        public Cookie[] getCookies() {
            return this.request.getCookies();
        }

        public Enumeration<String> getAttributeNames() {
            return this.request.getAttributeNames();
        }

        public long getDateHeader(String name) {
            return this.request.getDateHeader(name);
        }

        public String getCharacterEncoding() {
            return this.request.getCharacterEncoding();
        }

        public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
            this.request.setCharacterEncoding(env);
        }

        public int getContentLength() {
            return this.request.getContentLength();
        }

        public long getContentLengthLong() {
            return this.request.getContentLengthLong();
        }

        public Enumeration<String> getHeaders(String name) {
            return this.request.getHeaders(name);
        }

        public String getContentType() {
            return this.request.getContentType();
        }

        public ServletInputStream getInputStream() throws IOException {
            return this.request.getInputStream();
        }

        public String getParameter(String name) {
            return this.request.getParameter(name);
        }

        public Enumeration<String> getHeaderNames() {
            return this.request.getHeaderNames();
        }

        public int getIntHeader(String name) {
            return this.request.getIntHeader(name);
        }

        public Enumeration<String> getParameterNames() {
            return this.request.getParameterNames();
        }

        public String getMethod() {
            return this.request.getMethod();
        }

        public String[] getParameterValues(String name) {
            return this.request.getParameterValues(name);
        }

        public String getPathInfo() {
            return this.request.getPathInfo();
        }

        public Map<String, String[]> getParameterMap() {
            return this.request.getParameterMap();
        }

        public String getPathTranslated() {
            return this.request.getPathTranslated();
        }

        public String getProtocol() {
            return this.request.getProtocol();
        }

        public String getScheme() {
            return this.request.getScheme();
        }

        public String getContextPath() {
            return this.request.getContextPath();
        }

        public String getServerName() {
            return this.request.getServerName();
        }

        public int getServerPort() {
            return this.request.getServerPort();
        }

        public BufferedReader getReader() throws IOException {
            return this.request.getReader();
        }

        public String getQueryString() {
            return this.request.getQueryString();
        }

        public String getRemoteUser() {
            return this.request.getRemoteUser();
        }

        public String getRemoteAddr() {
            return this.request.getRemoteAddr();
        }

        public String getRemoteHost() {
            return this.request.getRemoteHost();
        }

        public boolean isUserInRole(String role) {
            return this.request.isUserInRole(role);
        }

        public void setAttribute(String name, Object o) {
            this.request.setAttribute(name, o);
        }

        public Principal getUserPrincipal() {
            return this.request.getUserPrincipal();
        }

        public void removeAttribute(String name) {
            this.request.removeAttribute(name);
        }

        public String getRequestedSessionId() {
            return this.request.getRequestedSessionId();
        }

        public Locale getLocale() {
            return this.request.getLocale();
        }

        public String getRequestURI() {
            return this.request.getRequestURI();
        }

        public Enumeration<Locale> getLocales() {
            return this.request.getLocales();
        }

        public boolean isSecure() {
            return this.request.isSecure();
        }

        public StringBuffer getRequestURL() {
            return this.request.getRequestURL();
        }

        public RequestDispatcher getRequestDispatcher(String path) {
            return this.request.getRequestDispatcher(path);
        }

        public String getServletPath() {
            return this.request.getServletPath();
        }

        public String getRealPath(String path) {
            return this.request.getRealPath(path);
        }

        public HttpSession getSession(boolean create) {
            return this.request.getSession(create);
        }

        public int getRemotePort() {
            return this.request.getRemotePort();
        }

        public String getLocalName() {
            return this.request.getLocalName();
        }

        public String getLocalAddr() {
            return this.request.getLocalAddr();
        }

        public int getLocalPort() {
            return this.request.getLocalPort();
        }

        public ServletContext getServletContext() {
            return this.request.getServletContext();
        }

        public HttpSession getSession() {
            return this.request.getSession();
        }

        public AsyncContext startAsync() throws IllegalStateException {
            return this.request.startAsync();
        }

        public String changeSessionId() {
            return this.request.changeSessionId();
        }

        public boolean isRequestedSessionIdValid() {
            return this.request.isRequestedSessionIdValid();
        }

        public boolean isRequestedSessionIdFromCookie() {
            return this.request.isRequestedSessionIdFromCookie();
        }

        public boolean isRequestedSessionIdFromURL() {
            return this.request.isRequestedSessionIdFromURL();
        }

        public boolean isRequestedSessionIdFromUrl() {
            return this.request.isRequestedSessionIdFromUrl();
        }

        public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
            return this.request.authenticate(response);
        }

        public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
            return this.request.startAsync(servletRequest, servletResponse);
        }

        public void login(String username, String password) throws ServletException {
            this.request.login(username, password);
        }

        public void logout() throws ServletException {
            this.request.logout();
        }

        public Collection<Part> getParts() throws IOException, ServletException {
            return this.request.getParts();
        }

        public boolean isAsyncStarted() {
            return this.request.isAsyncStarted();
        }

        public boolean isAsyncSupported() {
            return this.request.isAsyncSupported();
        }

        public Part getPart(String name) throws IOException, ServletException {
            return this.request.getPart(name);
        }

        public AsyncContext getAsyncContext() {
            return this.request.getAsyncContext();
        }

        public DispatcherType getDispatcherType() {
            return this.request.getDispatcherType();
        }

        public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
            return (T)this.request.upgrade(handlerClass);
        }
    }
}

