/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.auth;

import com.google.common.base.Optional;
import com.google.gson.JsonObject;
import io.corbel.lib.token.exception.TokenVerificationException;
import io.corbel.lib.token.parser.TokenParser;
import io.corbel.lib.token.reader.TokenReader;
import io.corbel.lib.ws.auth.AuthorizationInfo;
import io.corbel.lib.ws.auth.AuthorizationRulesService;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BearerTokenAuthenticator
implements Authenticator<String, AuthorizationInfo> {
    private static final Logger LOG = LoggerFactory.getLogger(BearerTokenAuthenticator.class);
    private final String audience;
    private final AuthorizationRulesService authorizationRulesService;
    private final TokenParser tokenParser;

    public BearerTokenAuthenticator(String audience, AuthorizationRulesService authorizationRulesService, TokenParser tokenParser) {
        this.audience = audience;
        this.authorizationRulesService = authorizationRulesService;
        this.tokenParser = tokenParser;
    }

    public Optional<AuthorizationInfo> authenticate(String token) throws AuthenticationException {
        try {
            TokenReader tokenReader = this.tokenParser.parseAndVerify(token);
            Set<JsonObject> accessRules = this.authorizationRulesService.getAuthorizationRules(token, this.audience);
            if (accessRules != null && !accessRules.isEmpty()) {
                return Optional.of((Object)new AuthorizationInfo(tokenReader, accessRules));
            }
        }
        catch (TokenVerificationException | IllegalArgumentException e) {
            LOG.trace("Invalid access token {}", (Object)token, (Object)e);
        }
        catch (Exception e) {
            LOG.error("Unexpected error when validating token", (Throwable)e);
            throw new AuthenticationException((Throwable)e);
        }
        return Optional.absent();
    }
}

