/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.auth;

import io.dropwizard.auth.AuthFactory;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.UnauthorizedHandler;
import io.dropwizard.auth.oauth.OAuthFactory;
import java.util.Arrays;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class CookieOAuthFactory<T>
extends AuthFactory<String, T> {
    private final OAuthFactory<T> oAuthFactory;
    private HttpServletRequest request;
    private static final String COOKIE_KEY = "token";
    private final String prefix = "Bearer";

    public CookieOAuthFactory(Authenticator<String, T> authenticator, String realm, Class<T> generatedClass) {
        super(authenticator);
        this.oAuthFactory = new OAuthFactory(authenticator, realm, generatedClass);
    }

    private CookieOAuthFactory(OAuthFactory<T> oAuthFactory) {
        super(oAuthFactory.authenticator());
        this.oAuthFactory = oAuthFactory;
    }

    public T provide() {
        Optional<Cookie> tokenCookie;
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null && (tokenCookie = Arrays.stream(cookies).filter(cookie -> cookie.getName().equals(COOKIE_KEY)).findFirst()).isPresent()) {
            this.oAuthFactory.setRequest((HttpServletRequest)new CustomAuthorizationHeaderHttpServletRequest(this.request, "Bearer " + tokenCookie.get().getValue()));
            return (T)this.oAuthFactory.provide();
        }
        return null;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
        this.oAuthFactory.setRequest(request);
    }

    public AuthFactory<String, T> clone(boolean required) {
        return new CookieOAuthFactory<T>((OAuthFactory)this.oAuthFactory.clone(required));
    }

    public void responseBuilder(UnauthorizedHandler unauthorizedHandler) {
        this.oAuthFactory.responseBuilder(unauthorizedHandler);
    }

    public Class<T> getGeneratedClass() {
        return this.oAuthFactory.getGeneratedClass();
    }

    private static class CustomAuthorizationHeaderHttpServletRequest
    extends HttpServletRequestWrapper {
        private final String customAuthorizationHeader;

        public CustomAuthorizationHeaderHttpServletRequest(HttpServletRequest request, String customAuthorizationHeader) {
            super(request);
            this.customAuthorizationHeader = customAuthorizationHeader;
        }

        public String getHeader(String name) {
            if (name.equals("Authorization")) {
                return this.customAuthorizationHeader;
            }
            return super.getHeader(name);
        }
    }
}

