/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.auth.ioc;

import com.google.gson.JsonObject;
import io.corbel.lib.ws.auth.AuthorizationInfoProvider;
import io.corbel.lib.ws.auth.AuthorizationRulesService;
import io.corbel.lib.ws.auth.DefaultAuthorizationRulesService;
import io.corbel.lib.ws.auth.repository.AuthorizationRulesRepository;
import io.corbel.lib.ws.auth.repository.RedisAuthorizationRulesRepository;
import io.corbel.lib.ws.filter.InformationResponseFilter;
import io.corbel.lib.ws.health.AuthorizationRedisHealthCheck;
import io.corbel.lib.ws.redis.GsonRedisSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class AuthorizationBasicIoc {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationBasicIoc.class);

    @Bean
    public AuthorizationRulesRepository getAuthorizationRulesRepository(RedisTemplate<String, JsonObject> redisTemplate) {
        return new RedisAuthorizationRulesRepository(redisTemplate);
    }

    @Bean
    public RedisTemplate<String, JsonObject> redisTemplate(JedisConnectionFactory jedisConnectionFactory) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory((RedisConnectionFactory)jedisConnectionFactory);
        template.setKeySerializer((RedisSerializer)new StringRedisSerializer());
        template.setValueSerializer(new GsonRedisSerializer());
        return template;
    }

    @Bean
    public JedisConnectionFactory jedisConnectionFactory(JedisPoolConfig jedisPoolConfig, @Value(value="${auth.redis.host:@null}") String host, @Value(value="${auth.redis.port:@null}") Integer port, @Value(value="${auth.redis.password:}") String password) {
        JedisConnectionFactory connFactory = new JedisConnectionFactory(jedisPoolConfig);
        connFactory.setPassword(password);
        if (host != null) {
            connFactory.setHostName(host);
        }
        if (port != null) {
            connFactory.setPort(port.intValue());
        }
        return connFactory;
    }

    @Bean
    public JedisPoolConfig jedisPoolConfig(@Value(value="${auth.redis.maxIdle:@null}") Integer maxIdle, @Value(value="${auth.redis.maxTotal:@null}") Integer maxTotal, @Value(value="${auth.redis.minIdle:@null}") Integer minIdle, @Value(value="${auth.redis.testOnBorrow:@null}") Boolean testOnBorrow, @Value(value="${auth.redis.testOnReturn:@null}") Boolean testOnReturn, @Value(value="${auth.redis.testWhileIdle:@null}") Boolean testWhileIdle, @Value(value="${auth.redis.numTestsPerEvictionRun:@null}") Integer numTestsPerEvictionRun, @Value(value="${auth.redis.maxWaitMillis:@null}") Long maxWaitMillis, @Value(value="${auth.redis.timeBetweenEvictionRunsMillis:@null}") Long timeBetweenEvictionRunsMillis, @Value(value="${auth.redis.blockWhenExhausted:@null}") Boolean blockWhenExhausted) {
        JedisPoolConfig config = new JedisPoolConfig();
        if (maxIdle != null) {
            config.setMaxIdle(maxIdle.intValue());
        }
        if (maxTotal != null) {
            config.setMaxTotal(maxTotal.intValue());
        }
        if (minIdle != null) {
            config.setMinIdle(minIdle.intValue());
        }
        if (testOnBorrow != null) {
            config.setTestOnBorrow(testOnBorrow.booleanValue());
        }
        if (testOnReturn != null) {
            config.setTestOnReturn(testOnReturn.booleanValue());
        }
        if (testWhileIdle != null) {
            config.setTestWhileIdle(testWhileIdle.booleanValue());
        }
        if (numTestsPerEvictionRun != null) {
            config.setNumTestsPerEvictionRun(numTestsPerEvictionRun.intValue());
        }
        if (timeBetweenEvictionRunsMillis != null) {
            config.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis.longValue());
        }
        if (maxWaitMillis != null) {
            config.setMaxWaitMillis(maxWaitMillis.longValue());
        }
        if (blockWhenExhausted != null) {
            config.setBlockWhenExhausted(blockWhenExhausted.booleanValue());
        }
        return config;
    }

    @Bean
    public AuthorizationRulesService authorizationRulesService(AuthorizationRulesRepository authorizationRulesRepository) {
        return new DefaultAuthorizationRulesService(authorizationRulesRepository);
    }

    @Bean
    public AuthorizationInfoProvider getAuthorizationInfoProvider() {
        return new AuthorizationInfoProvider();
    }

    @Bean
    public AuthorizationRedisHealthCheck getAuthorizationRedisHealthCheck(RedisTemplate<String, JsonObject> redisTemplate) {
        return new AuthorizationRedisHealthCheck(redisTemplate);
    }

    @Bean
    public InformationResponseFilter getRequestInformationRequestFilter() {
        return new InformationResponseFilter();
    }
}

