/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.auth.ioc;

import io.corbel.lib.token.ioc.TokenIoc;
import io.corbel.lib.token.parser.TokenParser;
import io.corbel.lib.ws.auth.AuthorizationInfo;
import io.corbel.lib.ws.auth.AuthorizationInfoProvider;
import io.corbel.lib.ws.auth.AuthorizationRulesService;
import io.corbel.lib.ws.auth.BearerTokenAuthenticator;
import io.corbel.lib.ws.auth.CookieOAuthFactory;
import io.corbel.lib.ws.auth.JsonUnauthorizedHandler;
import io.corbel.lib.ws.auth.ioc.AuthorizationBasicIoc;
import io.dropwizard.auth.Authenticator;
import io.dropwizard.auth.UnauthorizedHandler;
import io.dropwizard.auth.oauth.OAuthFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@Import(value={AuthorizationBasicIoc.class, TokenIoc.class})
public class AuthorizationCommonIoc {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizationCommonIoc.class);

    @Bean
    public Authenticator<String, AuthorizationInfo> authenticator(@Value(value="${auth.audience}") String audience, TokenParser tokenParser, AuthorizationRulesService authorizationRulesService) {
        return new BearerTokenAuthenticator(audience, authorizationRulesService, tokenParser);
    }

    @Bean
    public AuthorizationInfoProvider getAuthorizationInfoProvider() {
        return new AuthorizationInfoProvider();
    }

    @Bean
    public UnauthorizedHandler getUnauthorizedHandler() {
        return new JsonUnauthorizedHandler();
    }

    @Bean(name={"authProvider"})
    public OAuthFactory<AuthorizationInfo> getOAuthProvider(Authenticator<String, AuthorizationInfo> authenticator, @Value(value="${auth.realm}") String realm) {
        OAuthFactory oAuthFactory = new OAuthFactory(authenticator, realm, AuthorizationInfo.class);
        oAuthFactory.responseBuilder(this.getUnauthorizedHandler());
        return oAuthFactory;
    }

    @Bean(name={"cookieAuthProvider"})
    public CookieOAuthFactory<AuthorizationInfo> getCookieOAuthProvider(Authenticator<String, AuthorizationInfo> authenticator, @Value(value="${auth.realm}") String realm) {
        CookieOAuthFactory<AuthorizationInfo> cookieOAuthFactory = new CookieOAuthFactory<AuthorizationInfo>(authenticator, realm, AuthorizationInfo.class);
        cookieOAuthFactory.responseBuilder(this.getUnauthorizedHandler());
        return cookieOAuthFactory;
    }
}

