/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.auth.repository;

import com.google.gson.JsonObject;
import io.corbel.lib.ws.auth.repository.AuthorizationRulesRepository;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisAuthorizationRulesRepository
implements AuthorizationRulesRepository {
    private static final String AUTHORIZATION_RULES_KEY = "{0}|{1}";
    private final RedisTemplate<String, JsonObject> redisTemplate;

    public RedisAuthorizationRulesRepository(RedisTemplate<String, JsonObject> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Override
    public void save(String key, long timeToExpireInMillis, JsonObject ... rules) {
        this.redisTemplate.opsForSet().add((Object)key, (Object[])rules);
        this.redisTemplate.expire((Object)key, timeToExpireInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    @Override
    public Set<JsonObject> get(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    @Override
    public Long getTimeToExpire(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    @Override
    public void addRules(String key, JsonObject ... rules) {
        this.redisTemplate.opsForSet().add((Object)key, (Object[])rules);
    }

    @Override
    public void removeRules(String key, JsonObject ... rules) {
        this.redisTemplate.opsForSet().remove((Object)key, (Object[])rules);
    }

    @Override
    public String getKeyForAuthorizationRules(String token, String key) {
        return MessageFormat.format(AUTHORIZATION_RULES_KEY, token, key);
    }

    @Override
    public boolean existsRules(String key) {
        return !this.redisTemplate.keys((Object)key).isEmpty();
    }

    @Override
    public void deleteByToken(String token) {
        String patternToken = MessageFormat.format(AUTHORIZATION_RULES_KEY, token, "*");
        Set keysToDelete = this.redisTemplate.keys((Object)patternToken);
        this.redisTemplate.delete((Collection)keysToDelete);
    }
}

