/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.cli;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.joran.spi.JoranException;
import io.corbel.lib.cli.console.Console;
import io.corbel.lib.cli.console.Shell;
import io.corbel.lib.ws.cli.CommandLineI;
import io.corbel.lib.ws.log.LogbackUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class GenericConsole
implements CommandLineI {
    private String welcomeMessage;
    private Class<?> ioc;

    public GenericConsole(String namespace, Class<?> ioc) {
        this.welcomeMessage = "Welcome to " + namespace.toUpperCase() + ". Type " + namespace + ".help() to start.";
        this.ioc = ioc;
    }

    @Override
    public void run(List<String> args) {
        Console console = new Console(this.welcomeMessage, this.getShells());
        LogbackUtils.setLogLevel("INFO");
        try {
            this.removeUnneededLoggers();
            if (args.isEmpty()) {
                console.launch();
            } else {
                console.runScripts(args.toArray(new String[args.size()]));
            }
            System.exit(0);
        }
        catch (Throwable e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    private Map<String, Object> getShells() {
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext(new Class[]{this.ioc});
        Map beans = applicationContext.getBeansWithAnnotation(Shell.class);
        HashMap<String, Object> shells = new HashMap<String, Object>(beans.size());
        beans.forEach((beanName, bean) -> shells.put(((Shell)applicationContext.findAnnotationOnBean(beanName, Shell.class)).value(), bean));
        return shells;
    }

    private void removeUnneededLoggers() throws JoranException {
        ((Logger)LoggerFactory.getLogger((String)"ROOT")).detachAppender("FILE");
        ((Logger)LoggerFactory.getLogger((String)"ROOT")).detachAppender("SYSLOG");
    }
}

