/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.cors;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;

public class CorsResponseFilter
implements ContainerResponseFilter {
    private static final String SPACE = " ";
    private final List<String> allowedOrigins;
    private final int preflightRequestMaxAge;

    public static CorsResponseFilter disabled() {
        return new CorsResponseFilter(Collections.emptyList(), 0);
    }

    public static CorsResponseFilter anyOrigin(int preflightRequestMaxAge) {
        return new CorsResponseFilter(null, preflightRequestMaxAge);
    }

    public static CorsResponseFilter onlyAllowedOrigins(int preflightRequestMaxAge, String ... allowedOrigins) {
        return new CorsResponseFilter(Arrays.asList(allowedOrigins), preflightRequestMaxAge);
    }

    public CorsResponseFilter(List<String> allowedOrigins, int preflightRequestMaxAge) {
        this.allowedOrigins = allowedOrigins;
        this.preflightRequestMaxAge = preflightRequestMaxAge;
    }

    public void filter(ContainerRequestContext request, ContainerResponseContext response) {
        String origin;
        String string = origin = this.allowAnyOrigin() ? request.getHeaderString("Origin") : this.serializedOriginList();
        if (origin != null) {
            response.getHeaders().add((Object)"Access-Control-Allow-Credentials", (Object)true);
            response.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)origin);
            if (request.getMethod().equals("OPTIONS")) {
                response.getHeaders().add((Object)"Access-Control-Max-Age", (Object)this.preflightRequestMaxAge);
                response.getHeaders().add((Object)"Access-Control-Allow-Headers", (Object)Joiner.on((String)",").join((Object)"Authorization", (Object)"Accept", new Object[]{"Content-Type", "No-Redirect", "RequestCookie", "X-HTTP-Method-Override", "X-Challenge", "X-Captcha"}));
                response.getHeaders().add((Object)"Access-Control-Expose-Headers", (Object)Joiner.on((String)",").join((Object)"Location", (Object)"Date", new Object[0]));
                if (response.getHeaders().containsKey((Object)"Allow")) {
                    response.getHeaders().add((Object)"Access-Control-Allow-Methods", response.getHeaders().getFirst((Object)"Allow"));
                }
            } else if (response.getHeaders().containsKey((Object)"Location")) {
                response.getHeaders().add((Object)"Access-Control-Expose-Headers", (Object)"Location");
            }
        }
    }

    private boolean allowAnyOrigin() {
        return this.allowedOrigins == null;
    }

    private String serializedOriginList() {
        return this.allowedOrigins.isEmpty() ? null : Joiner.on((String)SPACE).join(this.allowedOrigins);
    }
}

