/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.digest;

import io.corbel.lib.ws.digest.Digester;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDigester
implements Digester {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDigester.class);
    private final String algorithm;
    private final String encoding;

    DefaultDigester(String algorithm) {
        this(algorithm, Charset.defaultCharset().toString());
    }

    DefaultDigester(String algorithm, String encoding) {
        this.algorithm = algorithm;
        this.encoding = encoding;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public String digest(String text) {
        MessageDigest md = null;
        try {
            String textToDigest = text;
            md = MessageDigest.getInstance(this.algorithm);
            md.update(textToDigest.getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage());
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error(e.getMessage());
        }
        return Hex.encodeHexString((byte[])md.digest());
    }
}

