/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.dw.ioc;

import ch.qos.logback.classic.Level;
import com.google.common.collect.ImmutableList;
import io.dropwizard.jetty.GzipFilterFactory;
import io.dropwizard.jetty.HttpConnectorFactory;
import io.dropwizard.logging.AppenderFactory;
import io.dropwizard.logging.ConsoleAppenderFactory;
import io.dropwizard.logging.FileAppenderFactory;
import io.dropwizard.logging.LoggingFactory;
import io.dropwizard.logging.SyslogAppenderFactory;
import io.dropwizard.server.DefaultServerFactory;
import io.dropwizard.util.Size;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DropwizardIoc {
    @Autowired
    private Environment env;

    @Bean
    public DefaultServerFactory getHttpConfiguration() {
        DefaultServerFactory configuration = new DefaultServerFactory();
        ((HttpConnectorFactory)configuration.getApplicationConnectors().get(0)).setPort(((Integer)this.env.getProperty("dw.http.port", Integer.class, (Object)8080)).intValue());
        ((HttpConnectorFactory)configuration.getApplicationConnectors().get(0)).setMaxRequestHeaderSize(Size.kilobytes((long)((Long)this.env.getProperty("dw.http.maxRequestHeaderSize", Long.class, (Object)16L))));
        ((HttpConnectorFactory)configuration.getAdminConnectors().get(0)).setPort(((Integer)this.env.getProperty("dw.http.adminPort", Integer.class, (Object)8081)).intValue());
        configuration.getRequestLogFactory().setAppenders(this.getLogConfiguration());
        configuration.setGzipFilterFactory(this.getGzipConfiguration());
        configuration.setRegisterDefaultExceptionMappers(Boolean.valueOf(false));
        return configuration;
    }

    @Bean
    public LoggingFactory getLoggingConfiguration() {
        LoggingFactory configuration = new LoggingFactory();
        configuration.setLevel(this.getLogLevel("dw.logging.level", "INFO"));
        configuration.setAppenders(this.getLogConfiguration());
        return configuration;
    }

    private ImmutableList<AppenderFactory> getLogConfiguration() {
        ImmutableList.Builder appenders = ImmutableList.builder();
        this.getConsoleConfiguration((ImmutableList.Builder<AppenderFactory>)appenders);
        this.getSyslogConfiguration((ImmutableList.Builder<AppenderFactory>)appenders);
        this.getFileConfiguration((ImmutableList.Builder<AppenderFactory>)appenders);
        return appenders.build();
    }

    private void getConsoleConfiguration(ImmutableList.Builder<AppenderFactory> appenders) {
        if (((Boolean)this.env.getProperty("dw.logging.console.enabled", Boolean.class, (Object)true)).booleanValue()) {
            ConsoleAppenderFactory configuration = new ConsoleAppenderFactory();
            configuration.setThreshold(this.getLogLevel("dw.logging.console.threshold", "ALL"));
            appenders.add((Object)configuration);
        }
    }

    private void getSyslogConfiguration(ImmutableList.Builder<AppenderFactory> appenders) {
        if (((Boolean)this.env.getProperty("dw.logging.syslog.enabled", Boolean.class, (Object)true)).booleanValue() && !this.isConsoleMode()) {
            SyslogAppenderFactory configuration = new SyslogAppenderFactory();
            configuration.setThreshold(this.getLogLevel("dw.logging.syslog.threshold", "ALL"));
            appenders.add((Object)configuration);
        }
    }

    private void getFileConfiguration(ImmutableList.Builder<AppenderFactory> appenders) {
        if (((Boolean)this.env.getProperty("dw.logging.file.enabled", Boolean.class, (Object)false)).booleanValue() && !this.isConsoleMode()) {
            FileAppenderFactory configuration = new FileAppenderFactory();
            configuration.setThreshold(this.getLogLevel("dw.logging.file.threshold", "ALL"));
            configuration.setCurrentLogFilename(this.env.getProperty("dw.logging.file.currentLogFilename", "./logs/app.log"));
            configuration.setArchivedLogFilenamePattern(this.env.getProperty("dw.logging.file.archivedLogFilenamePattern", "./logs/app-%d.log.gz"));
            appenders.add((Object)configuration);
        }
    }

    private GzipFilterFactory getGzipConfiguration() {
        GzipFilterFactory gzipConfiguration = new GzipFilterFactory();
        gzipConfiguration.setEnabled(false);
        return gzipConfiguration;
    }

    private Level getLogLevel(String property, String def) {
        String level = this.env.getProperty(property, def);
        return Level.toLevel((String)level);
    }

    private boolean isConsoleMode() {
        return Optional.ofNullable(System.getProperty("mode")).map(mode -> mode.equals("console")).orElse(false);
    }
}

