/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.ws.log;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogbackUtils {
    public static final String LOGBACK_CLASSIC = "ch.qos.logback.classic";
    public static final String LOGBACK_CLASSIC_LOGGER = "ch.qos.logback.classic.Logger";
    public static final String LOGBACK_CLASSIC_LEVEL = "ch.qos.logback.classic.Level";
    private static final Logger logger = LoggerFactory.getLogger(LogbackUtils.class);

    private LogbackUtils() {
    }

    public static boolean setLogLevel(String logLevel) {
        return LogbackUtils.setLogLevel(null, logLevel);
    }

    public static boolean setLogLevel(String loggerName, String logLevel) {
        String logLevelUpper = logLevel == null ? "OFF" : logLevel.toUpperCase();
        try {
            Logger loggerObtained;
            Package logbackPackage = Package.getPackage(LOGBACK_CLASSIC);
            if (logbackPackage == null) {
                logger.info("Logback is not in the classpath!");
                return false;
            }
            if (loggerName == null || loggerName.trim().isEmpty()) {
                loggerName = (String)LogbackUtils.getFieldVaulue(LOGBACK_CLASSIC_LOGGER, "ROOT_LOGGER_NAME");
            }
            if ((loggerObtained = LoggerFactory.getLogger((String)loggerName)) == null) {
                logger.warn("No logger for the name: {}", (Object)loggerName);
                return false;
            }
            Object logLevelObj = LogbackUtils.getFieldVaulue(LOGBACK_CLASSIC_LEVEL, logLevelUpper);
            if (logLevelObj == null) {
                logger.warn("No such log level: {}", (Object)logLevelUpper);
                return false;
            }
            Class[] paramTypes = new Class[]{logLevelObj.getClass()};
            Object[] params = new Object[]{logLevelObj};
            Class<?> clz = Class.forName(LOGBACK_CLASSIC_LOGGER);
            Method method = clz.getMethod("setLevel", paramTypes);
            method.invoke((Object)loggerObtained, params);
            logger.debug("Log level set to {} for the logger '{}'", (Object)logLevelUpper, (Object)loggerName);
            return true;
        }
        catch (Exception e) {
            logger.warn("Couldn't set log level to {} for the logger '{}'", (Object)new Object[]{logLevelUpper, loggerName}, (Object)e);
            return false;
        }
    }

    private static Object getFieldVaulue(String fullClassName, String fieldName) {
        try {
            Class<?> clazz = Class.forName(fullClassName);
            Field field = clazz.getField(fieldName);
            return field.get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ignored) {
            return null;
        }
    }
}

