/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.eventbus.service;

import io.corbel.eventbus.Event;
import io.corbel.eventbus.EventHandler;
import io.corbel.eventbus.service.EventBusRegistry;
import io.corbel.eventbus.service.IncomingEventProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIncomingEventProcessor
implements IncomingEventProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIncomingEventProcessor.class);
    private final EventBusRegistry registry;

    public DefaultIncomingEventProcessor(EventBusRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void process(Event event) {
        for (EventHandler<? extends Event> eventHandler : this.registry.getHandlers(event.getClass())) {
            try {
                eventHandler.handle(event);
            }
            catch (Exception e) {
                LOG.error("EventHandler raise exception. EventHandler: {} - Event: {} - Error: {}", new Object[]{eventHandler, event, e});
            }
        }
    }
}

