/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.eventbus.service;

import io.corbel.eventbus.Event;
import io.corbel.eventbus.EventHandler;
import io.corbel.eventbus.service.EventBusRegistry;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class InMemoryEventBusRegistry
implements EventBusRegistry {
    private final Map<Class<? extends Event>, List<EventHandler<? extends Event>>> eventHandlerMap;

    public InMemoryEventBusRegistry() {
        this.eventHandlerMap = new ConcurrentHashMap<Class<? extends Event>, List<EventHandler<? extends Event>>>();
    }

    public InMemoryEventBusRegistry(Map<Class<? extends Event>, List<EventHandler<? extends Event>>> eventHandlerMap) {
        this.eventHandlerMap = new ConcurrentHashMap<Class<? extends Event>, List<EventHandler<? extends Event>>>(eventHandlerMap);
    }

    @Override
    public <E extends Event> void register(EventHandler<E> eventHandler) {
        Class<E> registerClass = eventHandler.getEventType();
        List<EventHandler<? extends Event>> handlerList = this.eventHandlerMap.get(registerClass);
        if (handlerList == null) {
            handlerList = new CopyOnWriteArrayList<EventHandler<? extends Event>>();
            this.eventHandlerMap.put(registerClass, handlerList);
        }
        handlerList.add(eventHandler);
    }

    @Override
    public Iterable<EventHandler<? extends Event>> getHandlers(Class<? extends Event> eventType) {
        LinkedList mergedList = new LinkedList();
        mergedList.addAll(this.eventHandlerMap.getOrDefault(eventType, Collections.emptyList()));
        mergedList.addAll(this.eventHandlerMap.getOrDefault(Event.class, Collections.emptyList()));
        return Collections.unmodifiableList(mergedList);
    }
}

