/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.eventbus.service;

import io.corbel.eventbus.Event;
import io.corbel.eventbus.service.EventBus;
import org.springframework.amqp.core.AmqpTemplate;

public class RabbitEventBus
implements EventBus {
    private final AmqpTemplate amqpTemplate;
    private final String eventBusExchange;

    public RabbitEventBus(AmqpTemplate amqpTemplate, String eventBusExchange) {
        this.amqpTemplate = amqpTemplate;
        this.eventBusExchange = eventBusExchange;
    }

    @Override
    public void dispatch(Event event) {
        this.amqpTemplate.convertAndSend(this.eventBusExchange, event.getClass().toString(), (Object)event);
    }
}

