/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import com.rabbitmq.client.Channel;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactoryUtils;
import org.springframework.amqp.rabbit.connection.RabbitAccessor;
import org.springframework.amqp.rabbit.connection.RabbitResourceHolder;
import org.springframework.amqp.rabbit.connection.RabbitUtils;
import org.springframework.amqp.rabbit.connection.RoutingConnectionFactory;
import org.springframework.amqp.rabbit.core.ChannelAwareMessageListener;
import org.springframework.amqp.rabbit.listener.ConditionalRejectingErrorHandler;
import org.springframework.amqp.rabbit.listener.MessageListenerContainer;
import org.springframework.amqp.rabbit.listener.MessageRejectedWhileStoppingException;
import org.springframework.amqp.rabbit.listener.exception.FatalListenerExecutionException;
import org.springframework.amqp.rabbit.listener.exception.ListenerExecutionFailedException;
import org.springframework.amqp.support.converter.MessageConversionException;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.amqp.support.postprocessor.MessagePostProcessorUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public abstract class AbstractMessageListenerContainer
extends RabbitAccessor
implements MessageListenerContainer,
ApplicationContextAware,
BeanNameAware,
DisposableBean,
SmartLifecycle {
    public static final boolean DEFAULT_DEBATCHING_ENABLED = true;
    private volatile String beanName;
    private volatile boolean autoStartup = true;
    private int phase = Integer.MAX_VALUE;
    private volatile boolean active = false;
    private volatile boolean running = false;
    private final Object lifecycleMonitor = new Object();
    private volatile List<String> queueNames = new CopyOnWriteArrayList<String>();
    private ErrorHandler errorHandler = new ConditionalRejectingErrorHandler();
    private MessageConverter messageConverter;
    private boolean exposeListenerChannel = true;
    private volatile Object messageListener;
    private volatile AcknowledgeMode acknowledgeMode = AcknowledgeMode.AUTO;
    private volatile boolean deBatchingEnabled = true;
    private boolean initialized;
    private Collection<MessagePostProcessor> afterReceivePostProcessors;
    private volatile ApplicationContext applicationContext;

    public void setAcknowledgeMode(AcknowledgeMode acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public AcknowledgeMode getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public void setQueueNames(String ... queueName) {
        this.queueNames = new CopyOnWriteArrayList<String>(Arrays.asList(queueName));
    }

    public void setQueues(Queue ... queues) {
        List<String> queueNames = new ArrayList(queues.length);
        for (int i = 0; i < queues.length; ++i) {
            Assert.notNull((Object)queues[i], (String)"Queue must not be null.");
            queueNames.add(queues[i].getName());
        }
        queueNames = new CopyOnWriteArrayList(queueNames);
        this.queueNames = queueNames;
    }

    public String[] getQueueNames() {
        return this.queueNames.toArray(new String[this.queueNames.size()]);
    }

    protected String[] getRequiredQueueNames() {
        Assert.state((this.queueNames.size() > 0 ? 1 : 0) != 0, (String)"Queue names must not be empty.");
        return this.getQueueNames();
    }

    protected Set<String> getQueueNamesAsSet() {
        return new HashSet<String>(this.queueNames);
    }

    public void addQueueNames(String ... queueNames) {
        Assert.notNull((Object)queueNames, (String)"'queueNames' cannot be null");
        Assert.noNullElements((Object[])queueNames, (String)"'queueNames' cannot contain null elements");
        this.queueNames.addAll(Arrays.asList(queueNames));
    }

    public void addQueues(Queue ... queues) {
        Assert.notNull((Object)queues, (String)"'queues' cannot be null");
        Assert.noNullElements((Object[])queues, (String)"'queues' cannot contain null elements");
        String[] queueNames = new String[queues.length];
        for (int i = 0; i < queues.length; ++i) {
            queueNames[i] = queues[i].getName();
        }
        this.addQueueNames(queueNames);
    }

    public boolean removeQueueNames(String ... queueNames) {
        Assert.notNull((Object)queueNames, (String)"'queueNames' cannot be null");
        Assert.noNullElements((Object[])queueNames, (String)"'queueNames' cannot contain null elements");
        Assert.isTrue((this.queueNames.size() - queueNames.length > 0 ? 1 : 0) != 0, (String)"Cannot remove the last queue");
        return this.queueNames.removeAll(Arrays.asList(queueNames));
    }

    public boolean removeQueues(Queue ... queues) {
        Assert.notNull((Object)queues, (String)"'queues' cannot be null");
        Assert.noNullElements((Object[])queues, (String)"'queues' cannot contain null elements");
        String[] queueNames = new String[queues.length];
        for (int i = 0; i < queues.length; ++i) {
            queueNames[i] = queues[i].getName();
        }
        return this.removeQueueNames(queueNames);
    }

    public boolean isExposeListenerChannel() {
        return this.exposeListenerChannel;
    }

    public void setExposeListenerChannel(boolean exposeListenerChannel) {
        this.exposeListenerChannel = exposeListenerChannel;
    }

    public void setMessageListener(Object messageListener) {
        this.checkMessageListener(messageListener);
        this.messageListener = messageListener;
    }

    protected void checkMessageListener(Object messageListener) {
        if (!(messageListener instanceof MessageListener) && !(messageListener instanceof ChannelAwareMessageListener)) {
            throw new IllegalArgumentException("Message listener needs to be of type [" + MessageListener.class.getName() + "] or [" + ChannelAwareMessageListener.class.getName() + "]");
        }
    }

    public Object getMessageListener() {
        return this.messageListener;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    @Override
    public MessageConverter getMessageConverter() {
        return this.messageConverter;
    }

    public void setDeBatchingEnabled(boolean deBatchingEnabled) {
        this.deBatchingEnabled = deBatchingEnabled;
    }

    public void setAfterReceivePostProcessors(MessagePostProcessor ... afterReceivePostProcessors) {
        Assert.notNull((Object)afterReceivePostProcessors, (String)"'afterReceivePostProcessors' cannot be null");
        Assert.noNullElements((Object[])afterReceivePostProcessors, (String)"'afterReceivePostProcessors' cannot have null elements");
        this.afterReceivePostProcessors = MessagePostProcessorUtils.sort(Arrays.asList(afterReceivePostProcessors));
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    protected final String getBeanName() {
        return this.beanName;
    }

    protected final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        ConnectionFactory targetConnectionFactory;
        ConnectionFactory connectionFactory = super.getConnectionFactory();
        if (connectionFactory instanceof RoutingConnectionFactory && (targetConnectionFactory = ((RoutingConnectionFactory)((Object)connectionFactory)).getTargetConnectionFactory(this.queueNames.toString().replaceAll(" ", ""))) != null) {
            return targetConnectionFactory;
        }
        return connectionFactory;
    }

    @Override
    public final void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.state((this.exposeListenerChannel || !this.getAcknowledgeMode().isManual() ? 1 : 0) != 0, (String)"You cannot acknowledge messages manually if the channel is not exposed to the listener (please check your configuration and set exposeListenerChannel=true or acknowledgeMode!=MANUAL)");
        Assert.state((!this.getAcknowledgeMode().isAutoAck() || !this.isChannelTransacted() ? 1 : 0) != 0, (String)"The acknowledgeMode is NONE (autoack in Rabbit terms) which is not consistent with having a transactional channel. Either use a different AcknowledgeMode or make sure channelTransacted=false");
        this.validateConfiguration();
        this.initialize();
    }

    @Override
    public void setupMessageListener(Object messageListener) {
        this.setMessageListener(messageListener);
    }

    protected void validateConfiguration() {
    }

    public void destroy() {
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        try {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.lifecycleMonitor.notifyAll();
            }
            this.doInitialize();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.logger.debug((Object)"Shutting down Rabbit listener container");
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.active = false;
            this.lifecycleMonitor.notifyAll();
        }
        try {
            this.doShutdown();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            Object object2 = this.lifecycleMonitor;
            synchronized (object2) {
                this.running = false;
                this.lifecycleMonitor.notifyAll();
            }
        }
    }

    protected abstract void doInitialize() throws Exception;

    protected abstract void doShutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isActive() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.active;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.initialized) {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                if (!this.initialized) {
                    this.afterPropertiesSet();
                    this.initialized = true;
                }
            }
        }
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Starting Rabbit listener container.");
            }
            this.doStart();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.active = true;
            this.running = true;
            this.lifecycleMonitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception ex) {
            throw this.convertRabbitAccessException(ex);
        }
        finally {
            Object object = this.lifecycleMonitor;
            synchronized (object) {
                this.running = false;
                this.lifecycleMonitor.notifyAll();
            }
        }
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    protected void invokeErrorHandler(Throwable ex) {
        if (this.errorHandler != null) {
            this.errorHandler.handleError(ex);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn((Object)"Execution of Rabbit message listener failed, and no ErrorHandler has been set.", ex);
        }
    }

    protected void executeListener(Channel channel, Message messageIn) throws Throwable {
        if (!this.isRunning()) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Rejecting received message because the listener container has been stopped: " + messageIn));
            }
            throw new MessageRejectedWhileStoppingException();
        }
        try {
            Object batchFormat;
            Message message = messageIn;
            if (this.afterReceivePostProcessors != null) {
                for (MessagePostProcessor processor : this.afterReceivePostProcessors) {
                    message = processor.postProcessMessage(message);
                }
            }
            if ("lengthHeader4".equals(batchFormat = message.getMessageProperties().getHeaders().get("springBatchFormat")) && this.deBatchingEnabled) {
                ByteBuffer byteBuffer = ByteBuffer.wrap(message.getBody());
                MessageProperties messageProperties = message.getMessageProperties();
                messageProperties.getHeaders().remove("springBatchFormat");
                while (byteBuffer.hasRemaining()) {
                    int length = byteBuffer.getInt();
                    if (length < 0 || length > byteBuffer.remaining()) {
                        throw new ListenerExecutionFailedException("Bad batched message received", (Throwable)new MessageConversionException("Insufficient batch data at offset " + byteBuffer.position()), message);
                    }
                    byte[] body = new byte[length];
                    byteBuffer.get(body);
                    messageProperties.setContentLength((long)length);
                    Message fragment = new Message(body, messageProperties);
                    this.invokeListener(channel, fragment);
                }
            } else {
                this.invokeListener(channel, message);
            }
        }
        catch (Throwable ex) {
            this.handleListenerException(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokeListener(Channel channel, Message message) throws Exception {
        Object listener = this.getMessageListener();
        if (listener instanceof ChannelAwareMessageListener) {
            this.doInvokeListener((ChannelAwareMessageListener)listener, channel, message);
        } else if (listener instanceof MessageListener) {
            boolean bindChannel;
            boolean bl = bindChannel = this.isExposeListenerChannel() && this.isChannelLocallyTransacted(channel);
            if (bindChannel) {
                RabbitResourceHolder resourceHolder = new RabbitResourceHolder(channel, false);
                resourceHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)resourceHolder));
            }
            try {
                this.doInvokeListener((MessageListener)listener, message);
            }
            finally {
                if (bindChannel) {
                    TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
                }
            }
        } else {
            if (listener != null) {
                throw new FatalListenerExecutionException("Only MessageListener and SessionAwareMessageListener supported: " + listener);
            }
            throw new FatalListenerExecutionException("No message listener specified - see property 'messageListener'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doInvokeListener(ChannelAwareMessageListener listener, Channel channel, Message message) throws Exception {
        RabbitResourceHolder resourceHolder = null;
        Channel channelToUse = channel;
        boolean boundHere = false;
        try {
            if (!this.isExposeListenerChannel()) {
                resourceHolder = this.getTransactionalResourceHolder();
                channelToUse = resourceHolder.getChannel();
                if (this.isChannelLocallyTransacted(channelToUse) && !TransactionSynchronizationManager.isActualTransactionActive()) {
                    resourceHolder.setSynchronizedWithTransaction(true);
                    TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)resourceHolder));
                    boundHere = true;
                }
            } else if (this.isChannelLocallyTransacted(channel)) {
                RabbitResourceHolder localResourceHolder = new RabbitResourceHolder(channelToUse, false);
                localResourceHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.bindResource((Object)this.getConnectionFactory(), (Object)((Object)localResourceHolder));
                boundHere = true;
            }
            try {
                listener.onMessage(message, channelToUse);
            }
            catch (Exception e) {
                throw this.wrapToListenerExecutionFailedExceptionIfNeeded(e, message);
            }
        }
        finally {
            if (resourceHolder != null && boundHere) {
                resourceHolder.setSynchronizedWithTransaction(false);
            }
            ConnectionFactoryUtils.releaseResources(resourceHolder);
            if (boundHere) {
                TransactionSynchronizationManager.unbindResource((Object)this.getConnectionFactory());
                if (!this.isExposeListenerChannel() && this.isChannelLocallyTransacted(channelToUse)) {
                    RabbitUtils.commitIfNecessary(channelToUse);
                }
            }
        }
    }

    protected void doInvokeListener(MessageListener listener, Message message) throws Exception {
        try {
            listener.onMessage(message);
        }
        catch (Exception e) {
            throw this.wrapToListenerExecutionFailedExceptionIfNeeded(e, message);
        }
    }

    protected boolean isChannelLocallyTransacted(Channel channel) {
        return this.isChannelTransacted();
    }

    protected void handleListenerException(Throwable ex) {
        if (this.isActive()) {
            this.invokeErrorHandler(ex);
        } else {
            this.logger.debug((Object)"Listener exception after container shutdown", ex);
        }
    }

    protected Exception wrapToListenerExecutionFailedExceptionIfNeeded(Exception e, Message message) {
        if (!(e instanceof ListenerExecutionFailedException)) {
            return new ListenerExecutionFailedException("Listener threw exception", e, message);
        }
        return e;
    }

    public static class SharedConnectionNotInitializedException
    extends RuntimeException {
        protected SharedConnectionNotInitializedException(String msg) {
            super(msg);
        }
    }
}

