/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthFactory;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.Factory;
import org.glassfish.hk2.api.InjectionResolver;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.api.TypeLiteral;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.internal.inject.AbstractValueFactoryProvider;
import org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import org.glassfish.jersey.server.internal.inject.ParamInjectionResolver;
import org.glassfish.jersey.server.model.Parameter;
import org.glassfish.jersey.server.spi.internal.ValueFactoryProvider;

@Singleton
class AuthFactoryProvider<C, P>
extends AbstractValueFactoryProvider {
    private final AuthFactory<C, P> factory;

    @Inject
    public AuthFactoryProvider(MultivaluedParameterExtractorProvider extractorProvider, AuthFactory<C, P> factory, ServiceLocator injector) {
        super(extractorProvider, injector, new Parameter.Source[]{Parameter.Source.UNKNOWN});
        this.factory = factory;
    }

    protected Factory<?> createValueFactory(Parameter parameter) {
        Class classType = parameter.getRawType();
        Auth auth = (Auth)parameter.getAnnotation(Auth.class);
        if (auth != null && classType.isAssignableFrom(this.factory.getGeneratedClass())) {
            return this.factory.clone(auth.required());
        }
        return null;
    }

    public static class Binder<T, U>
    extends AbstractBinder {
        private AuthFactory<T, U> factory;

        public Binder(AuthFactory<T, U> factory) {
            this.factory = factory;
        }

        protected void configure() {
            this.bind(this.factory).to(AuthFactory.class);
            this.bind(AuthFactoryProvider.class).to(ValueFactoryProvider.class).in(Singleton.class);
            this.bind(AuthInjectionResolver.class).to((TypeLiteral)new TypeLiteral<InjectionResolver<Auth>>(){}).in(Singleton.class);
        }
    }

    public static class AuthInjectionResolver
    extends ParamInjectionResolver<Auth> {
        public AuthInjectionResolver() {
            super(AuthFactoryProvider.class);
        }
    }
}

