/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.token.factory;

import io.corbel.lib.token.TokenGrant;
import io.corbel.lib.token.TokenInfo;
import io.corbel.lib.token.factory.TokenFactory;
import io.corbel.lib.token.model.OneTimeAccessToken;
import io.corbel.lib.token.repository.OneTimeAccessTokenRepository;
import io.corbel.lib.token.serializer.TokenSerializer;
import io.corbel.lib.token.signer.TokenSigner;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Date;

public class BasicTokenFactory
implements TokenFactory {
    private final TokenSigner signer;
    private final TokenSerializer serializer;
    private final OneTimeAccessTokenRepository oneTimeAccessTokenRepository;
    private final Clock clock;

    public BasicTokenFactory(TokenSigner signer, TokenSerializer serializer, OneTimeAccessTokenRepository oneTimeAccessTokenRepository, Clock clock) {
        this.signer = signer;
        this.serializer = serializer;
        this.oneTimeAccessTokenRepository = oneTimeAccessTokenRepository;
        this.clock = clock;
    }

    @Override
    public TokenGrant createToken(TokenInfo info, long expiresIn, String ... tags) {
        Instant expireTime = this.clock.instant().plus(expiresIn, ChronoUnit.SECONDS);
        long expiresAt = expireTime.toEpochMilli();
        String token = this.serializer.serialize(info, expiresAt, this.signer);
        if (info.isOneUseToken()) {
            this.oneTimeAccessTokenRepository.save(new OneTimeAccessToken(token, Date.from(expireTime), Arrays.asList(tags)));
        }
        return new TokenGrant(token, expiresIn);
    }
}

