/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.token.parser;

import io.corbel.lib.token.TokenInfo;
import io.corbel.lib.token.exception.TokenVerificationException;
import io.corbel.lib.token.parser.TokenParser;
import io.corbel.lib.token.reader.TokenReader;
import io.corbel.lib.token.verifier.TokenVerifier;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.commons.lang3.Validate;

public class Base64BasicTokenParser
implements TokenParser {
    private final List<TokenVerifier> verifiers;

    public Base64BasicTokenParser(List<TokenVerifier> verifiers) {
        this.verifiers = verifiers;
    }

    @Override
    public TokenReader parseAndVerify(String token) throws TokenVerificationException {
        try {
            Reader reader = new Reader(token);
            for (TokenVerifier verifier : this.verifiers) {
                verifier.verify(reader);
            }
            return reader;
        }
        catch (IllegalArgumentException e) {
            throw new TokenVerificationException("Invalid token", e);
        }
    }

    private static class Reader
    implements TokenReader {
        private final String token;
        private final TokenInfo info;
        private final long expire;
        private final String signature;

        public Reader(String token) throws TokenVerificationException {
            try {
                this.token = token;
                String[] parts = token.split("\\.");
                Validate.isTrue((parts.length == 3 ? 1 : 0) != 0);
                this.info = TokenInfo.deserialize(this.decode(parts[0]));
                this.expire = Long.parseLong(parts[1], 16);
                this.signature = this.decode(parts[2]);
            }
            catch (UnsupportedEncodingException e) {
                throw new TokenVerificationException("Encoding problem", e);
            }
        }

        @Override
        public TokenInfo getInfo() {
            return this.info;
        }

        @Override
        public long getExpireTime() {
            return this.expire;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }

        @Override
        public String getToken() {
            return this.token;
        }

        private String decode(String string) throws UnsupportedEncodingException {
            return new String(Base64.getUrlDecoder().decode(string.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        }
    }
}

