/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.token.verifier;

import io.corbel.lib.token.exception.TokenVerificationException;
import io.corbel.lib.token.reader.TokenReader;
import io.corbel.lib.token.repository.OneTimeAccessTokenRepository;
import io.corbel.lib.token.verifier.TokenVerifier;

public class OneTimeAccessTokenVerifier
implements TokenVerifier {
    private final OneTimeAccessTokenRepository oneTimeAccessTokenRepository;

    public OneTimeAccessTokenVerifier(OneTimeAccessTokenRepository oneTimeAccessTokenRepository) {
        this.oneTimeAccessTokenRepository = oneTimeAccessTokenRepository;
    }

    @Override
    public void verify(TokenReader reader) throws TokenVerificationException {
        if (reader.getInfo().isOneUseToken() && this.oneTimeAccessTokenRepository.findAndRemove(reader.getToken()) == null) {
            throw new TokenVerificationException.TokenNotFound();
        }
    }
}

