/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth;

import com.codahale.metrics.health.HealthCheck;
import io.corbel.lib.token.provider.SessionProvider;
import io.corbel.lib.ws.cli.CommandLineI;
import io.corbel.lib.ws.cli.GenericConsole;
import io.corbel.lib.ws.cli.ServiceRunnerWithVersionResource;
import io.corbel.lib.ws.health.BasicHealthCheck;
import io.corbel.lib.ws.health.MongoHealthCheck;
import io.corbel.oauth.api.AuthorizeResource;
import io.corbel.oauth.api.SignoutResource;
import io.corbel.oauth.api.TokenResource;
import io.corbel.oauth.api.UserResource;
import io.corbel.oauth.api.UsernameResource;
import io.corbel.oauth.ioc.OauthIoc;
import io.dropwizard.setup.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class OauthRunner
extends ServiceRunnerWithVersionResource<OauthIoc> {
    private static final Logger LOG = LoggerFactory.getLogger(OauthRunner.class);

    public static void main(String[] args) {
        try {
            OauthRunner oauthRunner = new OauthRunner();
            oauthRunner.setCommandLine((CommandLineI)new GenericConsole(oauthRunner.getArtifactId(), OauthIoc.class));
            oauthRunner.run(args);
        }
        catch (Exception e) {
            LOG.error("Unable to start oauth-server", (Throwable)e);
        }
    }

    protected String getArtifactId() {
        return "oauth-server";
    }

    protected void configureService(Environment environment, ApplicationContext context) {
        super.configureService(environment, context);
        environment.jersey().register((Object)((SessionProvider)context.getBean(SessionProvider.class)).getBinder());
        environment.jersey().register(context.getBean(AuthorizeResource.class));
        environment.jersey().register(context.getBean(TokenResource.class));
        environment.jersey().register(context.getBean(UserResource.class));
        environment.jersey().register(context.getBean(UsernameResource.class));
        environment.jersey().register(context.getBean(SignoutResource.class));
        environment.healthChecks().register("basic", (HealthCheck)new BasicHealthCheck());
        environment.healthChecks().register("mongo", (HealthCheck)context.getBean(MongoHealthCheck.class));
    }
}

