/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.api;

import io.corbel.lib.token.TokenGrant;
import io.corbel.lib.token.TokenInfo;
import io.corbel.lib.token.factory.TokenFactory;
import io.corbel.lib.token.model.TokenType;
import io.corbel.lib.token.reader.TokenReader;
import io.corbel.lib.ws.api.error.ErrorMessage;
import io.corbel.lib.ws.api.error.ErrorResponseFactory;
import io.corbel.lib.ws.model.Error;
import io.corbel.oauth.filter.FilterRegistry;
import io.corbel.oauth.filter.exception.AuthFilterException;
import io.corbel.oauth.model.Client;
import io.corbel.oauth.model.ResponseType;
import io.corbel.oauth.model.User;
import io.corbel.oauth.service.ClientService;
import io.corbel.oauth.service.UserService;
import io.corbel.oauth.session.SessionBuilder;
import io.corbel.oauth.session.SessionCookieFactory;
import io.corbel.oauth.token.TokenExpireTime;
import java.net.URI;
import java.util.Optional;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.uri.internal.JerseyUriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="v1.0/oauth/authorize")
public class AuthorizeResource {
    private static final Logger LOG = LoggerFactory.getLogger(AuthorizeResource.class);
    private final UserService userService;
    private final TokenFactory tokenFactory;
    private final ClientService clientService;
    private final SessionCookieFactory sessionCookieFactory;
    private final TokenExpireTime tokenExpireTime;
    private final SessionBuilder sessionBuilder;
    private final FilterRegistry filterRegistry;

    public AuthorizeResource(UserService userService, TokenFactory tokenFactory, ClientService clientService, SessionCookieFactory sessionCookieFactory, TokenExpireTime tokenExpireTime, SessionBuilder sessionBuilder, FilterRegistry filterRegistry) {
        this.userService = userService;
        this.tokenFactory = tokenFactory;
        this.clientService = clientService;
        this.sessionCookieFactory = sessionCookieFactory;
        this.tokenExpireTime = tokenExpireTime;
        this.sessionBuilder = sessionBuilder;
        this.filterRegistry = filterRegistry;
    }

    @GET
    public Response authorize(@QueryParam(value="response_type") String responseType, @QueryParam(value="client_id") String clientId, @QueryParam(value="redirect_uri") String redirectUri, @CookieParam(value="SID") TokenReader session, @QueryParam(value="state") String state) {
        ResponseType tokenType = ResponseType.fromString(responseType);
        this.assertRequiredParameter(clientId, "client_id");
        Optional<Response> response = this.clientService.findByName(clientId).map(client -> {
            this.checkArguments(tokenType, (Client)client, redirectUri);
            return this.getTokenResponseFromSession(Optional.ofNullable(session), tokenType, (Client)client, redirectUri, Optional.ofNullable(state));
        }).orElse(Optional.of(ErrorResponseFactory.getInstance().unauthorized()));
        return response.orElse(ErrorResponseFactory.getInstance().notfound(new Error("not_found", "OAuth session not found")));
    }

    @POST
    public Response login(@FormParam(value="username") String username, @FormParam(value="password") String password, @FormParam(value="response_type") String responseType, @FormParam(value="client_id") String clientId, @FormParam(value="redirect_uri") String redirectUri, @FormParam(value="state") String state, @CookieParam(value="SID") TokenReader session, MultivaluedMap<String, String> form) {
        ResponseType tokenType = ResponseType.fromString(responseType);
        Optional<String> stateOptional = Optional.ofNullable(state);
        this.assertRequiredParameter(clientId, "client_id");
        return this.clientService.findByName(clientId).map(client -> {
            try {
                this.filterRegistry.filter(username, password, clientId, client.getDomain(), form);
            }
            catch (AuthFilterException e) {
                return ErrorResponseFactory.getInstance().unauthorized(e.getMessage());
            }
            if (StringUtils.isBlank((CharSequence)username) && StringUtils.isBlank((CharSequence)password)) {
                return this.tryLoginWithCookieSession((Client)client, redirectUri, Optional.ofNullable(session), tokenType, stateOptional);
            }
            return this.tryLoginWithUserCredentials(username, password, (Client)client, redirectUri, tokenType, stateOptional);
        }).orElse(ErrorResponseFactory.getInstance().unauthorized());
    }

    private Response tryLoginWithCookieSession(Client client, String redirectUri, Optional<TokenReader> session, ResponseType tokenType, Optional<String> stateOptional) {
        return this.getTokenResponseFromSession(session, tokenType, client, redirectUri, stateOptional).orElse(ErrorResponseFactory.getInstance().unauthorized());
    }

    private Response tryLoginWithUserCredentials(String user, String password, Client client, String redirectUri, ResponseType tokenType, Optional<String> stateOptional) {
        this.checkPostArguments(user, password, tokenType, client, redirectUri);
        Optional<String> loggedUser = this.signinWithUsername(user, password, client.getDomain());
        if (loggedUser.isPresent()) {
            return this.doResponse(loggedUser.get(), tokenType, client, redirectUri, stateOptional);
        }
        loggedUser = this.signinWithEmail(user, password, client.getDomain());
        if (loggedUser.isPresent()) {
            return this.doResponse(loggedUser.get(), tokenType, client, redirectUri, stateOptional);
        }
        return ErrorResponseFactory.getInstance().unauthorized();
    }

    private Optional<String> signinWithUsername(String username, String password, String domain) {
        User user = this.userService.findByUserNameAndDomain(username, domain);
        return this.signinInternal(user, password);
    }

    private Optional<String> signinWithEmail(String email, String password, String domain) {
        User user = this.userService.getUserByEmailAndDomain(email, domain);
        return this.signinInternal(user, password);
    }

    private Optional<String> signinInternal(User user, String password) {
        if (user != null && user.checkPassword(password)) {
            return Optional.of(user.getId());
        }
        return Optional.empty();
    }

    private Optional<Response> getTokenResponseFromSession(Optional<TokenReader> session, ResponseType tokenType, Client client, String redirectUri, Optional<String> state) {
        if (session.isPresent()) {
            LOG.debug("Authorizing logged-in user");
            TokenInfo tokenInfo = session.get().getInfo();
            return Optional.of(this.doResponse(tokenInfo.getUserId(), tokenType, client, redirectUri, state));
        }
        return Optional.empty();
    }

    private Response doResponse(String userId, ResponseType responseType, Client client, String redirectUri, Optional<String> state) {
        String session = this.sessionBuilder.createNewSession(client.getName(), userId);
        try {
            TokenGrant token = this.createToken(userId, responseType, client.getName());
            NewCookie cookie = this.sessionCookieFactory.createCookie(session);
            if (responseType == ResponseType.TOKEN) {
                return Response.ok().entity((Object)token).cookie(new NewCookie[]{cookie}).type(MediaType.APPLICATION_JSON_TYPE).build();
            }
            URI finalRedirectUri = this.buildRedirectUri(redirectUri, state, token.getAccessToken());
            return Response.seeOther((URI)finalRedirectUri).cookie(new NewCookie[]{cookie}).build();
        }
        catch (Exception e) {
            LOG.error("Unexpected error: {}", (Object)e.getMessage(), (Object)e);
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
    }

    private TokenGrant createToken(String userId, ResponseType responseType, String clientId) {
        TokenType tokenType = TokenType.valueOf((String)responseType.name());
        return this.tokenFactory.createToken(TokenInfo.newBuilder().setType(tokenType).setUserId(userId).setClientId(clientId).build(), this.tokenExpireTime.getTokenExpireTimeFromResponseType(tokenType), new String[0]);
    }

    private void checkPostArguments(String username, String password, ResponseType responseType, Client client, String redirectUri) {
        this.assertRequiredParameter(username, "username");
        this.assertRequiredParameter(password, "password");
        this.checkArguments(responseType, client, redirectUri);
    }

    private void checkArguments(ResponseType responseType, Client client, String redirectUri) {
        this.assertRequiredParameter((Object)responseType, "response_type");
        this.assertValidResponseType(responseType);
        this.assertRequiredParameter(client, "client_id");
        if (responseType == ResponseType.CODE) {
            this.assertRequiredParameter(redirectUri, "redirect_uri");
            this.checkRedirectUri(client, redirectUri);
        }
    }

    private void checkRedirectUri(Client client, String redirectUri) {
        if (!this.clientService.verifyRedirectUri(redirectUri, client)) {
            throw new WebApplicationException(ErrorResponseFactory.getInstance().unauthorized("Invalid redirect URI"));
        }
    }

    private URI buildRedirectUri(String redirectUri, Optional<String> state, String token) {
        JerseyUriBuilder uriBuilder = new JerseyUriBuilder();
        uriBuilder.uri(URI.create(redirectUri));
        if (state.isPresent()) {
            uriBuilder.queryParam("state", new Object[]{state.get()});
        }
        uriBuilder.queryParam("code", new Object[]{token});
        return uriBuilder.build(new Object[0]);
    }

    private void assertRequiredParameter(Object value, String parameterName) {
        if (value == null || value instanceof String && StringUtils.isEmpty((CharSequence)((String)value))) {
            throw new WebApplicationException(ErrorResponseFactory.getInstance().missingParameter(parameterName));
        }
    }

    private void assertValidResponseType(ResponseType responseType) {
        if (responseType == ResponseType.INVALID) {
            throw new WebApplicationException(ErrorResponseFactory.getInstance().badRequest(new Error("invalid_response_type", ErrorMessage.BAD_REQUEST.getMessage(new Object[0]))));
        }
    }
}

