/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.api;

import io.corbel.lib.token.reader.TokenReader;
import io.corbel.oauth.session.SessionCookieFactory;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;

@Path(value="v1.0/oauth/signout")
public class SignoutResource {
    private final SessionCookieFactory sessionCookieFactory;

    public SignoutResource(SessionCookieFactory sessionCookieFactory) {
        this.sessionCookieFactory = sessionCookieFactory;
    }

    @GET
    public Response signout(@CookieParam(value="SID") TokenReader session) {
        Response.ResponseBuilder responseBuilder = Response.noContent();
        if (null != session) {
            String token = session.getToken();
            NewCookie cookie = this.sessionCookieFactory.destroyCookie(token);
            responseBuilder.cookie(new NewCookie[]{cookie});
        }
        return responseBuilder.build();
    }
}

