/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.api;

import io.corbel.lib.token.TokenGrant;
import io.corbel.lib.token.TokenInfo;
import io.corbel.lib.token.exception.TokenVerificationException;
import io.corbel.lib.token.factory.TokenFactory;
import io.corbel.lib.token.model.TokenType;
import io.corbel.lib.token.parser.TokenParser;
import io.corbel.lib.token.reader.TokenReader;
import io.corbel.lib.ws.api.error.ErrorResponseFactory;
import io.corbel.lib.ws.model.Error;
import io.corbel.oauth.model.Client;
import io.corbel.oauth.model.User;
import io.corbel.oauth.repository.UserRepository;
import io.corbel.oauth.service.ClientService;
import io.corbel.oauth.token.TokenExpireTime;
import java.io.Serializable;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="v1.0/oauth/token")
public class TokenResource {
    private static final String AUTHORIZATION_CODE_GRANT_TYPE = "authorization_code";
    private static final Logger LOG = LoggerFactory.getLogger(TokenResource.class);
    private final TokenParser tokenParser;
    private final TokenFactory tokenFactory;
    private final ClientService clientService;
    private final UserRepository userRepository;
    private final TokenExpireTime tokenExpireTime;

    public TokenResource(TokenParser tokenParser, TokenFactory tokenFactory, ClientService clientService, UserRepository userRepository, TokenExpireTime tokenExpireTime) {
        this.tokenParser = tokenParser;
        this.tokenFactory = tokenFactory;
        this.clientService = clientService;
        this.userRepository = userRepository;
        this.tokenExpireTime = tokenExpireTime;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response accessToken(@FormParam(value="grant_type") String grantType, @FormParam(value="code") String code, @FormParam(value="client_id") String clientId, @FormParam(value="client_secret") String clientSecret, @FormParam(value="validated_mail_required") Boolean validatedMailRequired) {
        if (StringUtils.isBlank((CharSequence)grantType)) {
            return ErrorResponseFactory.getInstance().missingParameter("grant_type");
        }
        if (StringUtils.isBlank((CharSequence)clientId)) {
            return ErrorResponseFactory.getInstance().missingParameter("client_id");
        }
        if (StringUtils.isBlank((CharSequence)clientSecret)) {
            return ErrorResponseFactory.getInstance().missingParameter("client_secret");
        }
        if (this.isNotSupportedGrantType(grantType)) {
            return ErrorResponseFactory.getInstance().badRequest(new Error("invalid_grant", grantType));
        }
        if (StringUtils.isBlank((CharSequence)code)) {
            return ErrorResponseFactory.getInstance().missingParameter("code");
        }
        Client client = this.clientService.findByName(clientId).orElseThrow(() -> new WebApplicationException(ErrorResponseFactory.getInstance().unauthorized()));
        try {
            TokenReader tokenReader = this.tokenParser.parseAndVerify(code);
            if (TokenType.CODE != tokenReader.getInfo().getTokenType()) {
                LOG.debug("Invalid token type: " + tokenReader.getInfo().getTokenType());
                return ErrorResponseFactory.getInstance().unauthorized();
            }
            if (!this.tokenHasClientIdAndValidSecret(tokenReader, client, clientSecret)) {
                LOG.debug("Invalid clientId and/or secret");
                return ErrorResponseFactory.getInstance().unauthorized();
            }
            if (BooleanUtils.isTrue((Boolean)validatedMailRequired) && !this.userHasValidatedEmail(tokenReader)) {
                return ErrorResponseFactory.getInstance().unauthorized("User need validate e-mail");
            }
            TokenInfo tokenInfo = TokenInfo.newBuilder().setType(TokenType.TOKEN).setUserId(tokenReader.getInfo().getUserId()).setClientId(tokenReader.getInfo().getClientId()).setDomainId(client.getDomain()).build();
            TokenGrant token = this.tokenFactory.createToken(tokenInfo, this.tokenExpireTime.getTokenExpireTimeFromResponseType(TokenType.TOKEN), new String[0]);
            return Response.ok().entity((Object)token).type(MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (TokenVerificationException e) {
            LOG.debug("Token verification failed", (Throwable)e);
            return ErrorResponseFactory.getInstance().unauthorized();
        }
    }

    private boolean userHasValidatedEmail(TokenReader tokenReader) {
        User user = (User)this.userRepository.findOne((Serializable)((Object)tokenReader.getInfo().getUserId()));
        if (user != null) {
            return user.isEmailValidated();
        }
        return false;
    }

    private boolean tokenHasClientIdAndValidSecret(TokenReader tokenReader, Client client, String clientSecret) {
        return StringUtils.equals((CharSequence)tokenReader.getInfo().getClientId(), (CharSequence)client.getName()) && this.clientService.verifyClientSecret(clientSecret, client);
    }

    private boolean isNotSupportedGrantType(String grantType) {
        return !AUTHORIZATION_CODE_GRANT_TYPE.equals(grantType);
    }
}

