/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.api;

import io.corbel.lib.token.reader.TokenReader;
import io.corbel.lib.ws.api.error.ErrorResponseFactory;
import io.corbel.lib.ws.model.Error;
import io.corbel.oauth.model.Client;
import io.corbel.oauth.model.Role;
import io.corbel.oauth.model.User;
import io.corbel.oauth.repository.CreateUserException;
import io.corbel.oauth.service.ClientService;
import io.corbel.oauth.service.UserService;
import io.dropwizard.auth.Auth;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="v1.0/user")
public class UserResource {
    private static final String ME = "me";
    private final UserService userService;
    private final ClientService clientService;

    public UserResource(UserService userService, ClientService clientService) {
        this.userService = userService;
        this.clientService = clientService;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response create(@Context UriInfo uriInfo, @Auth Client client, @Valid User user) {
        try {
            user.setRole(Role.USER);
            user.setId(null);
            String id = this.userService.createUser(user, client);
            return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(id).build(new Object[0])).build();
        }
        catch (CreateUserException.DuplicatedUser duplicatedUser) {
            return ErrorResponseFactory.getInstance().conflict(new Error("entity_exists", "User already exists"));
        }
    }

    @Path(value="/{id}")
    @GET
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="id") String id, @Auth TokenReader token) {
        User user = this.getUserFromIdAliases(id, token);
        return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)user.getUser()).build();
    }

    @Path(value="/{id}/profile")
    @GET
    @Produces(value={"application/json"})
    public Response getUserProfile(@PathParam(value="id") String id, @Auth TokenReader token) {
        User user = this.getUserFromIdAliases(id, token);
        return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity((Object)user.getUserProfile()).build();
    }

    @Path(value="/{id}/avatar")
    @GET
    public Response getAvatar(@PathParam(value="id") String id, @Auth TokenReader token) {
        User user = this.getUserFromIdAliases(id, token);
        return Optional.ofNullable(user.getAvatarUri()).map(avatarUriAsString -> {
            try {
                return new URI((String)avatarUriAsString);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }).map(avatarUri -> Response.temporaryRedirect((URI)avatarUri).build()).orElseGet(() -> ErrorResponseFactory.getInstance().notfound(new Error("not_found", "User " + id + " has no avatar.")));
    }

    @Path(value="/{id}")
    @PUT
    @Consumes(value={"application/json"})
    public Response update(@PathParam(value="id") String id, @Auth TokenReader token, User userUpdatedData) {
        if (userUpdatedData == null) {
            return ErrorResponseFactory.getInstance().badRequest(new Error("bad_request", "Invalid update data"));
        }
        try {
            Client client = this.clientService.findByName(token.getInfo().getClientId()).orElseThrow(() -> new WebApplicationException(ErrorResponseFactory.getInstance().unauthorized()));
            userUpdatedData.setEmailValidated(null);
            User user = this.getUserFromIdAliases(id, token);
            this.checkUpdateUserRolePermissions(token.getInfo().getUserId(), userUpdatedData.getRole());
            this.userService.updateUser(user, userUpdatedData, client);
            return Response.noContent().build();
        }
        catch (CreateUserException.DuplicatedUser duplicatedUser) {
            return ErrorResponseFactory.getInstance().conflict(new Error("entity_exists", "User already exists"));
        }
    }

    @Path(value="/{id}/emailConfirmation")
    @PUT
    @Consumes(value={"application/json"})
    public Response confirmEmail(@PathParam(value="id") String id, @Auth TokenReader token) {
        String state = token.getInfo().getState();
        if (state == null) {
            return ErrorResponseFactory.getInstance().badRequest();
        }
        this.userService.confirmEmail(state);
        return Response.noContent().build();
    }

    @Path(value="/{id}")
    @DELETE
    public Response delete(@PathParam(value="id") String id, @Auth TokenReader token) {
        User user = this.getUserFromIdAliases(id, token);
        this.userService.deleteUser(user.getId());
        return Response.noContent().build();
    }

    @Path(value="/{id}/validate")
    @GET
    public Response generateValidationEmail(@PathParam(value="id") String id, @Auth TokenReader token) {
        User user = this.getUserFromIdAliases(id, token);
        return this.clientService.findByName(token.getInfo().getClientId()).map(client -> {
            this.userService.sendValidationEmail(user, (Client)client);
            return Response.ok().build();
        }).orElse(ErrorResponseFactory.getInstance().notFound());
    }

    @Path(value="/resetPassword")
    @GET
    public Response generateResetPasswordEmail(@Auth Client client, @QueryParam(value="email") String email) {
        this.userService.sendMailResetPassword(email, client);
        return Response.noContent().build();
    }

    private User getUserFromIdAliases(String id, TokenReader token) {
        String userId = token.getInfo().getUserId();
        User authenticatedUser = this.userService.getUser(userId);
        if (ME.equals(id) || id.equals(userId)) {
            return authenticatedUser;
        }
        User user = this.userService.getUser(id);
        if (user != null && authenticatedUser.getRole().canUpdate(user.getRole()) && user.getDomain().equals(authenticatedUser.getDomain())) {
            return user;
        }
        throw new WebApplicationException(ErrorResponseFactory.getInstance().notFound());
    }

    private void checkUpdateUserRolePermissions(String userId, Role role) {
        User authenticatedUser;
        if (role != null && !(authenticatedUser = this.userService.getUser(userId)).getRole().canChangeRoleTo(role)) {
            throw new WebApplicationException(ErrorResponseFactory.getInstance().forbidden());
        }
    }
}

