/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.api;

import io.corbel.lib.token.reader.TokenReader;
import io.corbel.lib.ws.api.error.ErrorResponseFactory;
import io.corbel.lib.ws.model.Error;
import io.corbel.oauth.model.User;
import io.corbel.oauth.service.UserService;
import io.dropwizard.auth.Auth;
import java.util.Optional;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

@Path(value="v1.0/username")
public class UsernameResource {
    private final UserService userService;

    public UsernameResource(UserService userService) {
        this.userService = userService;
    }

    @Path(value="/{username}")
    @HEAD
    public Response existUsername(@PathParam(value="username") String username, @Auth TokenReader token) {
        String domain = token.getInfo().getDomainId();
        return this.userService.existsByUsernameAndDomain(username, domain) ? Response.ok().build() : ErrorResponseFactory.getInstance().notfound(new Error("not_found", "User " + username + " does not exist."));
    }

    @Path(value="/{username}")
    @GET
    @Produces(value={"application/json"})
    public Response getUserIdByUsername(@PathParam(value="username") String username, @Auth TokenReader token) {
        return this.getUserInDomainByUsername(username, token).map(user -> Response.ok((Object)user.getUserWithOnlyId()).type(MediaType.APPLICATION_JSON_TYPE).build()).orElseGet(() -> ErrorResponseFactory.getInstance().notfound(new Error("not_found", "User " + username + " does not exist.")));
    }

    private Optional<User> getUserInDomainByUsername(String username, TokenReader token) {
        String domain = token.getInfo().getDomainId();
        return Optional.ofNullable(this.userService.findByUserNameAndDomain(username, domain));
    }
}

