/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.api.auth;

import com.google.common.base.Optional;
import io.corbel.lib.token.exception.TokenVerificationException;
import io.corbel.lib.token.parser.TokenParser;
import io.corbel.lib.token.reader.TokenReader;
import io.dropwizard.auth.AuthenticationException;
import io.dropwizard.auth.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenAuthenticator
implements Authenticator<String, TokenReader> {
    private static final Logger LOG = LoggerFactory.getLogger(TokenAuthenticator.class);
    private final TokenParser tokenParser;

    public TokenAuthenticator(TokenParser tokenParser) {
        this.tokenParser = tokenParser;
    }

    public Optional<TokenReader> authenticate(String token) throws AuthenticationException {
        try {
            TokenReader tokenReader = this.tokenParser.parseAndVerify(token);
            return Optional.of((Object)tokenReader);
        }
        catch (TokenVerificationException e) {
            LOG.debug("Token verification failed: {}", (Object)e.getMessage());
            return Optional.absent();
        }
    }
}

