/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.filter;

import io.corbel.oauth.filter.AuthFilter;
import io.corbel.oauth.filter.FilterRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class AuthFilterRegistrar
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(AuthFilterRegistrar.class);
    private final FilterRegistry registry;

    public AuthFilterRegistrar(FilterRegistry registry) {
        this.registry = registry;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        for (AuthFilter filter : context.getBeansOfType(AuthFilter.class).values()) {
            LOG.info("Registering auth filter {} of domain {}", (Object)filter.getClass().getName(), (Object)filter.getDomain());
            this.registry.registerFilter(filter);
        }
    }
}

