/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.corbel.lib.ws.digest.DigesterFactory;
import io.corbel.oauth.model.Role;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.data.annotation.Id;

public class User {
    @Id
    private String id;
    private String domain;
    @Pattern(regexp="^(?!.*\\|).*$")
    @NotEmpty
    private String username;
    @NotEmpty
    private String password;
    @NotEmpty
    @Email
    private String email;
    private String salt;
    private Boolean emailValidated;
    private Role role;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String avatarUri;

    public Boolean getEmailValidated() {
        return this.emailValidated;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password != null) {
            this.salt = DigesterFactory.generateSalt();
            password = DigesterFactory.md5((String)this.salt).digest(password);
        }
        this.password = password;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Boolean isEmailValidated() {
        return this.emailValidated;
    }

    public void setEmailValidated(Boolean emailValidated) {
        this.emailValidated = emailValidated;
    }

    public String getSalt() {
        return this.salt;
    }

    private void setSalt(String salt) {
        this.salt = salt;
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public boolean checkPassword(String password) {
        return Objects.equals(DigesterFactory.md5((String)this.getSalt()).digest(password), this.password);
    }

    public void addProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    @JsonIgnore
    public User getUser() {
        this.setDomain(null);
        this.setPassword(null);
        this.setSalt(null);
        return this;
    }

    @JsonIgnore
    public User getUserProfile() {
        User profile = new User();
        profile.setUsername(this.username);
        profile.setEmail(this.email);
        profile.setProperties(this.properties);
        profile.setAvatarUri(this.avatarUri);
        return profile;
    }

    @JsonIgnore
    public User getUserWithOnlyId() {
        User returnedUser = new User();
        returnedUser.setId(this.getId());
        return returnedUser;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public String getAvatarUri() {
        return this.avatarUri;
    }

    public void setAvatarUri(String avatarUri) {
        this.avatarUri = avatarUri;
    }

    public void updateFields(User updateUser) {
        if (updateUser.getUsername() != null) {
            this.setUsername(updateUser.getUsername());
        }
        if (updateUser.getEmail() != null && !updateUser.getEmail().equals(this.getEmail())) {
            this.setEmail(updateUser.getEmail());
            this.setEmailValidated(false);
        }
        if (updateUser.getPassword() != null) {
            this.password = updateUser.getPassword();
            this.salt = updateUser.getSalt();
        }
        if (updateUser.getRole() != null) {
            this.setRole(updateUser.getRole());
        }
        if (updateUser.getProperties() != null && !updateUser.getProperties().isEmpty()) {
            for (Map.Entry<String, Object> entry : updateUser.getProperties().entrySet()) {
                if (entry.getValue() == null) {
                    this.removeProperty(entry.getKey());
                    continue;
                }
                this.addProperty(entry.getKey(), entry.getValue());
            }
        }
        Optional.ofNullable(updateUser.getAvatarUri()).ifPresent(newAvatar -> {
            if (newAvatar.isEmpty()) {
                this.setAvatarUri(null);
            } else {
                this.setAvatarUri((String)newAvatar);
            }
        });
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof User)) {
            return false;
        }
        User that = (User)obj;
        return Objects.equals(this.email, that.email) && Objects.equals(this.password, that.password) && Objects.equals(this.username, that.username);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.domain);
    }
}

