/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.repository;

import io.corbel.lib.mongo.index.MongoIndex;
import io.corbel.oauth.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;

public class MongoIndexes {
    private static final Logger LOG = LoggerFactory.getLogger(MongoIndexes.class);

    @Autowired
    public void ensureIndexes(MongoOperations mongo) {
        LOG.info("Creating mongo indexes");
        mongo.indexOps(User.class).ensureIndex(new MongoIndex().on("username", Sort.Direction.ASC).on("domain", Sort.Direction.ASC).unique().background().getIndexDefinition());
        mongo.indexOps(User.class).ensureIndex(new MongoIndex().on("email", Sort.Direction.ASC).on("domain", Sort.Direction.ASC).unique().background().getIndexDefinition());
    }
}

