/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.repository.decorator;

import io.corbel.oauth.model.User;
import io.corbel.oauth.repository.UserRepository;
import java.io.Serializable;
import java.util.List;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public abstract class UserRepositoryDecorator
implements UserRepository {
    protected UserRepository decoratedUserRepository;

    public UserRepositoryDecorator(UserRepository decoratedUserRepository) {
        this.decoratedUserRepository = decoratedUserRepository;
    }

    @Override
    public User findByUsername(String username) {
        return this.decoratedUserRepository.findByUsername(username);
    }

    @Override
    public User findByEmail(String email) {
        return this.decoratedUserRepository.findByEmail(email);
    }

    @Override
    public User findById(String id) {
        return this.decoratedUserRepository.findById(id);
    }

    public User save(User s) {
        return (User)this.decoratedUserRepository.save(s);
    }

    public <S extends User> List<S> save(Iterable<S> ses) {
        return this.decoratedUserRepository.save(ses);
    }

    public User findOne(String s) {
        return (User)this.decoratedUserRepository.findOne((Serializable)((Object)s));
    }

    public boolean exists(String s) {
        return this.decoratedUserRepository.exists((Serializable)((Object)s));
    }

    public List<User> findAll() {
        return this.decoratedUserRepository.findAll();
    }

    public Iterable<User> findAll(Iterable<String> strings) {
        return this.decoratedUserRepository.findAll(strings);
    }

    public long count() {
        return this.decoratedUserRepository.count();
    }

    public void delete(String s) {
        this.decoratedUserRepository.delete((Serializable)((Object)s));
    }

    public void delete(User user) {
        this.decoratedUserRepository.delete(user);
    }

    public void delete(Iterable<? extends User> users) {
        this.decoratedUserRepository.delete(users);
    }

    public void deleteAll() {
        this.decoratedUserRepository.deleteAll();
    }

    @Override
    public User findByEmailAndDomain(String email, String domain) {
        return this.decoratedUserRepository.findByEmailAndDomain(email, domain);
    }

    @Override
    public User findByUsernameAndDomain(String username, String domain) {
        return this.decoratedUserRepository.findByUsernameAndDomain(username, domain);
    }

    @Override
    public boolean existsByUsernameAndDomain(String username, String domainId) {
        return this.decoratedUserRepository.existsByUsernameAndDomain(username, domainId);
    }

    public boolean patch(String id, User data, String ... fieldsToDelete) {
        return this.decoratedUserRepository.patch((Serializable)((Object)id), data, fieldsToDelete);
    }

    public boolean patch(User data, String ... fieldsToDelete) {
        return this.decoratedUserRepository.patch(data, fieldsToDelete);
    }

    public boolean upsert(String id, User data) {
        return this.decoratedUserRepository.upsert((Serializable)((Object)id), data);
    }

    public Page<User> findAll(Pageable pageable) {
        return this.decoratedUserRepository.findAll(pageable);
    }

    public List<User> findAll(Sort sort) {
        return this.decoratedUserRepository.findAll(sort);
    }

    public <S extends User> List<S> findAll(Example<S> example) {
        return this.decoratedUserRepository.findAll(example);
    }

    public <S extends User> S insert(S s) {
        return (S)((User)this.decoratedUserRepository.insert(s));
    }

    public <S extends User> List<S> insert(Iterable<S> iterable) {
        return this.decoratedUserRepository.insert(iterable);
    }

    public <S extends User> List<S> findAll(Example<S> example, Sort sort) {
        return this.decoratedUserRepository.findAll(example, sort);
    }

    public <S extends User> S findOne(Example<S> example) {
        return (S)((User)this.decoratedUserRepository.findOne(example));
    }

    public <S extends User> Page<S> findAll(Example<S> example, Pageable pageable) {
        return this.decoratedUserRepository.findAll(example, pageable);
    }

    public <S extends User> long count(Example<S> example) {
        return this.decoratedUserRepository.count(example);
    }

    public <S extends User> boolean exists(Example<S> example) {
        return this.decoratedUserRepository.exists(example);
    }
}

