/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.service;

import com.google.common.collect.ImmutableMap;
import io.corbel.oauth.model.Client;
import io.corbel.oauth.service.MailChangePasswordService;
import io.corbel.oauth.service.SendNotificationService;
import java.util.Map;
import java.util.Optional;

public class DefaultMailChangePasswordService
implements MailChangePasswordService {
    private final String notificationId;
    private final SendNotificationService sendNotificationService;

    public DefaultMailChangePasswordService(String notificationId, SendNotificationService sendNotificationService) {
        this.notificationId = notificationId;
        this.sendNotificationService = sendNotificationService;
    }

    @Override
    public void sendMailChangePassword(Client client, String username, String email) {
        String changePasswordNotificationId = Optional.ofNullable(client.getChangePasswordNotificationId()).orElse(this.notificationId);
        this.sendNotificationService.sendNotification(client.getDomain(), changePasswordNotificationId, email, (Map<String, String>)ImmutableMap.of((Object)"username", (Object)username));
    }
}

