/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.service;

import com.google.common.collect.ImmutableMap;
import io.corbel.lib.token.TokenInfo;
import io.corbel.lib.token.factory.TokenFactory;
import io.corbel.lib.token.model.TokenType;
import io.corbel.oauth.mail.NotificationConfiguration;
import io.corbel.oauth.model.Client;
import io.corbel.oauth.service.MailResetPasswordService;
import io.corbel.oauth.service.SendNotificationService;
import java.util.Map;
import java.util.Optional;

public class DefaultMailResetPasswordService
implements MailResetPasswordService {
    private final NotificationConfiguration mailConfiguration;
    private final SendNotificationService sendNotificationService;
    private final TokenFactory tokenFactory;

    public DefaultMailResetPasswordService(NotificationConfiguration notificationConfiguration, SendNotificationService sendNotificationService, TokenFactory tokenFactory) {
        this.sendNotificationService = sendNotificationService;
        this.mailConfiguration = notificationConfiguration;
        this.tokenFactory = tokenFactory;
    }

    @Override
    public void sendMailResetPassword(Client client, String userId, String email) {
        String resetUrl = Optional.ofNullable(client.getResetUrl()).orElse(this.mailConfiguration.getClientUrl());
        String notificationId = Optional.ofNullable(client.getResetNotificationId()).orElse(this.mailConfiguration.getNotificationId());
        String clientUrl = resetUrl.replace("{token}", this.createEmailResetPasswordToken(client.getName(), userId));
        this.sendNotificationService.sendNotification(client.getDomain(), notificationId, email, (Map<String, String>)ImmutableMap.of((Object)"clientUrl", (Object)clientUrl));
    }

    private String createEmailResetPasswordToken(String clientId, String userId) {
        return this.tokenFactory.createToken(TokenInfo.newBuilder().setType(TokenType.TOKEN).setUserId(userId).setClientId(clientId).setOneUseToken(true).build(), this.mailConfiguration.getTokenDurationInSeconds(), new String[0]).getAccessToken();
    }
}

