/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.service;

import com.google.common.collect.ImmutableMap;
import io.corbel.lib.token.TokenInfo;
import io.corbel.lib.token.factory.TokenFactory;
import io.corbel.lib.token.model.TokenType;
import io.corbel.oauth.mail.EmailValidationConfiguration;
import io.corbel.oauth.model.Client;
import io.corbel.oauth.service.ClientService;
import io.corbel.oauth.service.MailValidationService;
import io.corbel.oauth.service.SendNotificationService;
import java.util.Map;
import java.util.Optional;

public class DefaultMailValidationService
implements MailValidationService {
    private final EmailValidationConfiguration emailValidationConfiguration;
    private final SendNotificationService sendNotificationService;
    private final TokenFactory tokenFactory;
    private final ClientService clientService;

    public DefaultMailValidationService(EmailValidationConfiguration emailValidationConfiguration, SendNotificationService sendNotificationService, TokenFactory tokenFactory, ClientService clientService) {
        this.sendNotificationService = sendNotificationService;
        this.emailValidationConfiguration = emailValidationConfiguration;
        this.tokenFactory = tokenFactory;
        this.clientService = clientService;
    }

    @Override
    public void sendMailValidation(Client client, String userId, String email) {
        Boolean validatedEnabled = Optional.of(client.isValidationEnabled()).orElse(this.emailValidationConfiguration.isValidationEnabled());
        if (validatedEnabled.booleanValue()) {
            String validationtUrl = Optional.ofNullable(client.getValidationUrl()).orElse(this.emailValidationConfiguration.getClientUrl());
            String notificationId = Optional.ofNullable(client.getValidationNotificationId()).orElse(this.emailValidationConfiguration.getNotificationId());
            String clientUrl = validationtUrl.replace("{token}", this.createEmailValidationToken(client.getName(), userId, email));
            this.sendNotificationService.sendNotification(client.getDomain(), notificationId, email, (Map<String, String>)ImmutableMap.of((Object)"clientUrl", (Object)clientUrl));
        }
    }

    private String createEmailValidationToken(String clientId, String userId, String email) {
        return this.tokenFactory.createToken(TokenInfo.newBuilder().setType(TokenType.TOKEN).setUserId(userId).setClientId(clientId).setState(email).setOneUseToken(true).build(), this.emailValidationConfiguration.getTokenDurationInSeconds(), new String[0]).getAccessToken();
    }
}

