/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.service;

import io.corbel.oauth.model.Client;
import io.corbel.oauth.model.User;
import io.corbel.oauth.repository.CreateUserException;
import io.corbel.oauth.repository.UserRepository;
import io.corbel.oauth.service.MailChangePasswordService;
import io.corbel.oauth.service.MailResetPasswordService;
import io.corbel.oauth.service.MailValidationService;
import io.corbel.oauth.service.UserService;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.dao.DataIntegrityViolationException;

public class DefaultUserService
implements UserService {
    private final UserRepository userRepository;
    private final MailValidationService mailValidationService;
    private final MailResetPasswordService mailResetPasswordService;
    private final MailChangePasswordService mailChangePasswordService;

    public DefaultUserService(UserRepository userRepository, MailValidationService mailValidationService, MailResetPasswordService mailResetPasswordService, MailChangePasswordService mailChangePasswordService) {
        this.userRepository = userRepository;
        this.mailValidationService = mailValidationService;
        this.mailResetPasswordService = mailResetPasswordService;
        this.mailChangePasswordService = mailChangePasswordService;
    }

    @Override
    public User getUser(String userId) {
        return (User)this.userRepository.findOne((Serializable)((Object)userId));
    }

    @Override
    public User getUserByEmailAndDomain(String email, String domain) {
        return this.userRepository.findByEmailAndDomain(email, domain);
    }

    @Override
    public void deleteUser(String userId) {
        this.userRepository.delete((Serializable)((Object)userId));
    }

    @Override
    public boolean existsByUsernameAndDomain(String username, String domainId) {
        return this.userRepository.existsByUsernameAndDomain(username, domainId);
    }

    @Override
    public User findByUserNameAndDomain(String username, String domain) {
        return this.userRepository.findByUsernameAndDomain(username, domain);
    }

    @Override
    public void updateUser(User user, User userData, Client client) throws CreateUserException.DuplicatedUser {
        try {
            boolean changePassword = userData.getPassword() != null && !Objects.equals(user.getPassword(), userData.getPassword());
            boolean changeEmail = userData.getEmail() != null && !Objects.equals(user.getEmail(), userData.getEmail());
            user.updateFields(userData);
            this.userRepository.save(user);
            if (changePassword) {
                this.notifyChangePassword(client, user);
            }
            if (changeEmail) {
                this.mailValidationService.sendMailValidation(client, user.getId(), userData.getEmail());
            }
        }
        catch (DataIntegrityViolationException e) {
            throw new CreateUserException.DuplicatedUser();
        }
    }

    @Override
    public String createUser(User user, Client client) throws CreateUserException.DuplicatedUser {
        user.setEmailValidated(false);
        user.setDomain(client.getDomain());
        try {
            user = (User)this.userRepository.save(user);
            this.mailValidationService.sendMailValidation(client, user.getId(), user.getEmail());
            return user.getId();
        }
        catch (DataIntegrityViolationException e) {
            throw new CreateUserException.DuplicatedUser();
        }
    }

    @Override
    public void sendMailResetPassword(String email, Client client) {
        User user = this.getUserByEmailAndDomain(email, client.getDomain());
        if (user != null) {
            this.mailResetPasswordService.sendMailResetPassword(client, user.getId(), email);
        }
    }

    @Override
    public void sendValidationEmail(User user, Client client) {
        String currentEmail = user.getEmail();
        this.mailValidationService.sendMailValidation(client, user.getId(), currentEmail);
    }

    @Override
    public boolean confirmEmail(String email) {
        User user = this.userRepository.findByEmail(email);
        if (user != null) {
            User update = new User();
            update.setEmailValidated(true);
            return this.userRepository.patch((Serializable)((Object)user.getId()), update, new String[0]);
        }
        return false;
    }

    private void notifyChangePassword(Client client, User user) {
        this.mailChangePasswordService.sendMailChangePassword(client, user.getUsername(), user.getEmail());
    }
}

