/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.session;

import io.corbel.lib.token.TokenGrant;
import io.corbel.lib.token.TokenInfo;
import io.corbel.lib.token.factory.TokenFactory;
import io.corbel.lib.token.model.TokenType;
import io.corbel.oauth.session.SessionBuilder;

public class DefaultSessionBuilder
implements SessionBuilder {
    private final TokenFactory tokenFactory;
    private final long sessionMaxAge;

    public DefaultSessionBuilder(TokenFactory tokenFactory, long sessionMaxAge) {
        this.tokenFactory = tokenFactory;
        this.sessionMaxAge = sessionMaxAge;
    }

    @Override
    public String createNewSession(String clientId, String userId) {
        TokenInfo newSession = TokenInfo.newBuilder().setType(TokenType.REFRESH).setClientId(clientId).setUserId(userId).setState(Long.toString(System.currentTimeMillis())).setOneUseToken(true).build();
        TokenGrant token = this.tokenFactory.createToken(newSession, this.sessionMaxAge, new String[0]);
        return token.getAccessToken();
    }
}

