/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.oauth.session;

import io.corbel.oauth.session.SessionCookieFactory;
import javax.ws.rs.core.NewCookie;

public class DefaultSessionCookieFactory
implements SessionCookieFactory {
    private static final String DELETED = "deleted";
    private static final int COOKIE_VERSION = 1;
    private final String path;
    private final String domain;
    private final String comment;
    private final int maxAge;
    private final boolean secure;

    public DefaultSessionCookieFactory(String path, String domain, String comment, Integer maxAge, Boolean secure) {
        this.path = path;
        this.domain = domain;
        this.comment = comment;
        this.maxAge = maxAge != null ? maxAge : 0;
        this.secure = secure != null ? secure : false;
    }

    @Override
    public NewCookie createCookie(String session) {
        return new NewCookie("SID", session, this.path, this.domain, 1, this.comment, this.maxAge, this.secure);
    }

    @Override
    public NewCookie destroyCookie(String session) {
        return new NewCookie("SID", DELETED, this.path, this.domain, 1, this.comment, -1, this.secure);
    }
}

