/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries;

import io.corbel.lib.queries.exception.QueryMatchingException;
import io.corbel.lib.queries.request.QueryLiteral;
import java.util.Date;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public class DateQueryLiteral
extends QueryLiteral<Date> {
    public DateQueryLiteral() {
    }

    public DateQueryLiteral(Date date) {
        super(date);
    }

    @Override
    protected boolean eq(Object object) throws QueryMatchingException {
        return ((Date)object).equals(this.literal);
    }

    @Override
    protected boolean ne(Object object) throws QueryMatchingException {
        return !((Date)object).equals(this.literal);
    }

    @Override
    protected boolean gt(Object object) throws QueryMatchingException {
        return ((Date)object).after((Date)this.literal);
    }

    @Override
    protected boolean gte(Object object) throws QueryMatchingException {
        Date extractDate = (Date)object;
        return extractDate.equals(this.literal) || extractDate.after((Date)this.literal);
    }

    @Override
    protected boolean lt(Object object) throws QueryMatchingException {
        return ((Date)object).before((Date)this.literal);
    }

    @Override
    protected boolean lte(Object object) throws QueryMatchingException {
        Date extractDate = (Date)object;
        return extractDate.equals(this.literal) || extractDate.before((Date)this.literal);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.literal == null ? 0 : ((Date)this.literal).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateQueryLiteral other = (DateQueryLiteral)obj;
        return !(this.literal == null ? other.literal != null : !((Date)this.literal).equals(other.literal));
    }

    public String toString() {
        return "\"ISODate(" + ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC).print(((Date)this.literal).getTime()) + ")\"";
    }
}

