/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries;

import io.corbel.lib.queries.exception.QueryMatchingException;
import io.corbel.lib.queries.model.Coordinates;
import io.corbel.lib.queries.model.Position;
import io.corbel.lib.queries.request.QueryLiteral;

public class PositionQueryLiteral
extends QueryLiteral<Position> {
    public PositionQueryLiteral() {
    }

    public PositionQueryLiteral(Position position) {
        super(position);
    }

    @Override
    protected boolean near(Object object) throws QueryMatchingException {
        Coordinates coordinates = (Coordinates)object;
        return this.near(((Position)this.literal).getCoordinates().getLatitude(), ((Position)this.literal).getCoordinates().getLongitude(), coordinates.getLatitude(), coordinates.getLongitude(), ((Position)this.literal).getMaxDistance());
    }

    private boolean near(double latitude1, double longitude1, double latitude2, double longitude2, double maxDistance) {
        double theta = longitude1 - longitude2;
        double distance = Math.sin(PositionQueryLiteral.deg2rad(latitude1)) * Math.sin(PositionQueryLiteral.deg2rad(latitude2)) + Math.cos(PositionQueryLiteral.deg2rad(latitude1)) * Math.cos(PositionQueryLiteral.deg2rad(latitude2)) * Math.cos(PositionQueryLiteral.deg2rad(theta));
        distance = Math.acos(distance);
        distance = PositionQueryLiteral.rad2deg(distance);
        distance = distance * 60.0 * 1.1515;
        return maxDistance >= (distance *= 1609.344);
    }

    private static double deg2rad(double deg) {
        return deg * Math.PI / 180.0;
    }

    private static double rad2deg(double rad) {
        return rad * 180.0 / Math.PI;
    }

    public String toString() {
        return ((Position)this.getLiteral()).toString();
    }
}

