/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries;

import io.corbel.lib.queries.exception.QueryMatchingException;
import io.corbel.lib.queries.request.QueryLiteral;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringQueryLiteral
extends QueryLiteral<String> {
    public StringQueryLiteral() {
    }

    public StringQueryLiteral(String literal) {
        super(literal);
    }

    @Override
    protected boolean eq(Object object) throws QueryMatchingException {
        if (object instanceof Collection) {
            for (Object entry : (Collection)object) {
                if (!((String)this.literal).equals(entry.toString())) continue;
                return true;
            }
            return false;
        }
        return object.toString().equals(this.literal);
    }

    @Override
    protected boolean ne(Object object) throws QueryMatchingException {
        return !this.eq(object);
    }

    @Override
    protected boolean like(Object object) throws QueryMatchingException {
        Pattern pattern = Pattern.compile((String)this.literal, 2);
        if (object instanceof Collection) {
            for (Object entry : (Collection)object) {
                Matcher matcher = pattern.matcher(entry.toString());
                if (!matcher.matches()) continue;
                return true;
            }
            return false;
        }
        String stringObject = object.toString();
        Matcher matcher = pattern.matcher(stringObject);
        return matcher.matches();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.literal == null ? 0 : ((String)this.literal).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringQueryLiteral other = (StringQueryLiteral)obj;
        return !(this.literal == null ? other.literal != null : !((String)this.literal).equals(other.literal));
    }

    public String toString() {
        return "\"" + (String)this.getLiteral() + "\"";
    }
}

