/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

public class Coordinates {
    private double latitude;
    private double longitude;

    @JsonCreator
    public Coordinates(@JsonProperty(value="latitude", required=true) Double latitude, @JsonProperty(value="longitude", required=true) Double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Coordinates that = (Coordinates)o;
        if (Double.compare(that.latitude, this.latitude) != 0) {
            return false;
        }
        return Double.compare(that.longitude, this.longitude) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.latitude);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "coordinates{latitude: " + this.latitude + ", longitude: " + this.longitude + '}';
    }
}

