/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.parser;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.corbel.lib.queries.exception.MalformedJsonQueryException;
import java.io.IOException;

public class CustomJsonParser {
    private final JsonFactory jsonFactory;

    public CustomJsonParser(JsonFactory jsonFactory) {
        this.jsonFactory = jsonFactory;
    }

    public JsonNode readValueAsTree(String json) throws MalformedJsonQueryException {
        try {
            return (JsonNode)this.jsonFactory.createParser(json).readValueAsTree();
        }
        catch (JsonProcessingException e) {
            throw new MalformedJsonQueryException("Json parse exception", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MalformedJsonQueryException("IOexception", e);
        }
    }

    public <T> T readValueAsObject(JsonNode node, Class<T> clazz) throws MalformedJsonQueryException {
        try {
            return (T)this.jsonFactory.createParser(node.toString()).readValueAs(clazz);
        }
        catch (JsonProcessingException e) {
            throw new MalformedJsonQueryException("Unexpected object for this operation", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MalformedJsonQueryException("IOexception", e);
        }
    }
}

