/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.parser;

import com.fasterxml.jackson.databind.JsonNode;
import io.corbel.lib.queries.exception.MalformedJsonQueryException;
import io.corbel.lib.queries.parser.AggregationParser;
import io.corbel.lib.queries.parser.CustomJsonParser;
import io.corbel.lib.queries.request.Aggregation;
import io.corbel.lib.queries.request.AggregationOperator;
import io.corbel.lib.queries.request.Average;
import io.corbel.lib.queries.request.Combine;
import io.corbel.lib.queries.request.Count;
import io.corbel.lib.queries.request.Histogram;
import io.corbel.lib.queries.request.Max;
import io.corbel.lib.queries.request.Min;
import io.corbel.lib.queries.request.Sum;
import java.util.Iterator;
import java.util.Map;

public class JacksonAggregationParser
implements AggregationParser {
    private final CustomJsonParser jsonParser;

    public JacksonAggregationParser(CustomJsonParser jsonParser) {
        this.jsonParser = jsonParser;
    }

    @Override
    public Aggregation parse(String aggregation) throws MalformedJsonQueryException {
        JsonNode node = this.jsonParser.readValueAsTree(aggregation);
        if (node.isObject()) {
            return this.getOperationFromNode(node);
        }
        throw new MalformedJsonQueryException("Unexpected array");
    }

    private Aggregation getOperationFromNode(JsonNode node) throws MalformedJsonQueryException {
        Iterator fieldNames = node.fieldNames();
        if (fieldNames.hasNext()) {
            String key = (String)fieldNames.next();
            if (fieldNames.hasNext()) {
                throw new MalformedJsonQueryException("Wrong number of fields (Expected one)");
            }
            JsonNode value = node.get(key);
            switch (this.getOperator(key)) {
                case $COUNT: {
                    return new Count(value.asText());
                }
                case $AVG: {
                    return new Average(value.asText());
                }
                case $SUM: {
                    return new Sum(value.asText());
                }
                case $MAX: {
                    return new Max(value.asText());
                }
                case $MIN: {
                    return new Min(value.asText());
                }
                case $COMBINE: {
                    Map.Entry entry = (Map.Entry)value.fields().next();
                    return new Combine((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
                }
                case $HISTOGRAM: {
                    return new Histogram(value.asText());
                }
            }
            return null;
        }
        throw new MalformedJsonQueryException("Empty object");
    }

    private AggregationOperator getOperator(String key) throws MalformedJsonQueryException {
        try {
            return AggregationOperator.valueOf(key.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MalformedJsonQueryException("Unknown aggregation operator " + key);
        }
    }
}

