/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.parser;

import com.fasterxml.jackson.databind.JsonNode;
import io.corbel.lib.queries.BooleanQueryLiteral;
import io.corbel.lib.queries.DateQueryLiteral;
import io.corbel.lib.queries.DoubleQueryLiteral;
import io.corbel.lib.queries.ListQueryLiteral;
import io.corbel.lib.queries.LongQueryLiteral;
import io.corbel.lib.queries.PositionQueryLiteral;
import io.corbel.lib.queries.QueryNodeImpl;
import io.corbel.lib.queries.ResourceQueryQueryLiteral;
import io.corbel.lib.queries.StringQueryLiteral;
import io.corbel.lib.queries.exception.MalformedJsonQueryException;
import io.corbel.lib.queries.model.Position;
import io.corbel.lib.queries.parser.CustomJsonParser;
import io.corbel.lib.queries.parser.QueryParser;
import io.corbel.lib.queries.request.QueryLiteral;
import io.corbel.lib.queries.request.QueryNode;
import io.corbel.lib.queries.request.QueryOperator;
import io.corbel.lib.queries.request.ResourceQuery;
import java.time.Duration;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.format.ISODateTimeFormat;

public class JacksonQueryParser
implements QueryParser {
    private static final String OPERATOR_START = "$";
    private static final Pattern ISO_DATE_PATTERN = Pattern.compile("^ISODate[(](.*?)[)]$");
    private static final Pattern PERIOD_PATTERN = Pattern.compile("^Period[(](.*?)[)]$");
    private final CustomJsonParser jsonParser;

    public JacksonQueryParser(CustomJsonParser jsonParser) {
        this.jsonParser = jsonParser;
    }

    @Override
    public ResourceQuery parse(String queryString) throws MalformedJsonQueryException {
        JsonNode nodes = this.jsonParser.readValueAsTree(queryString);
        return this.getParseQueriesFromTree(nodes);
    }

    private ResourceQuery getParseQueriesFromTree(JsonNode nodes) throws MalformedJsonQueryException {
        ResourceQuery resourceQuery = new ResourceQuery();
        for (JsonNode node : nodes) {
            if (node.isObject()) {
                resourceQuery.addQueryNode(this.getQueryNodeFromJsonNode(node));
                continue;
            }
            throw new MalformedJsonQueryException("Unexpected array");
        }
        return resourceQuery;
    }

    private QueryNode getQueryNodeFromJsonNode(JsonNode node) throws MalformedJsonQueryException {
        Iterator fieldNames = node.fieldNames();
        if (fieldNames.hasNext()) {
            String key = (String)fieldNames.next();
            if (fieldNames.hasNext()) {
                throw new MalformedJsonQueryException("Wrong number of fields (Expected one)");
            }
            if (key.startsWith(OPERATOR_START)) {
                return this.getQueryNode(this.getOperator(key), node.get(key));
            }
            return this.getQueryNode(QueryOperator.$EQ, node);
        }
        throw new MalformedJsonQueryException("Empty object");
    }

    private QueryOperator getOperator(String key) throws MalformedJsonQueryException {
        try {
            return QueryOperator.valueOf(key.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new MalformedJsonQueryException("Unknown operator " + key);
        }
    }

    private QueryNodeImpl getQueryNode(QueryOperator operator, JsonNode nodeField) throws MalformedJsonQueryException {
        if (nodeField.fieldNames().hasNext()) {
            String field = (String)nodeField.fieldNames().next();
            QueryLiteral<?> value = this.generateQueryLiteral(nodeField.get(field), operator);
            return new QueryNodeImpl(operator, field, value);
        }
        throw new MalformedJsonQueryException("Empty filter");
    }

    private QueryLiteral<?> generateQueryLiteral(JsonNode nodeField, QueryOperator operator) throws MalformedJsonQueryException {
        if (nodeField.isObject()) {
            if (!operator.isObjectOperator()) {
                throw new MalformedJsonQueryException("Unsupported operation. Only $NEAR support operations with objects.");
            }
            return this.generateObjectQueryLiteral(nodeField, operator);
        }
        if (nodeField.isArray()) {
            if (!operator.isArrayOperator()) {
                throw new MalformedJsonQueryException("Unsupported operation. Only $ALL, $IN, $NIN and $ELEM_MATCH support operations with arrays.");
            }
            if (operator == QueryOperator.$ELEM_MATCH) {
                return this.generateResourceQueryQueryLiteral(nodeField);
            }
            return this.generateArrayQueryLiteral(nodeField);
        }
        if (operator.isArrayOperator() || operator.isObjectOperator()) {
            throw new MalformedJsonQueryException("Unsupported operation. Only $EQ, $GT, $GTE, $LT, $LTE, $NE, $SIZE and $LIKE support operations with primitives.");
        }
        return this.generatePrimitiveQueryLiteral(nodeField);
    }

    private QueryLiteral<?> generateResourceQueryQueryLiteral(JsonNode nodeField) throws MalformedJsonQueryException {
        ResourceQueryQueryLiteral literal = new ResourceQueryQueryLiteral();
        literal.setLiteral(this.getParseQueriesFromTree(nodeField));
        return literal;
    }

    private QueryLiteral<?> generateObjectQueryLiteral(JsonNode nodeField, QueryOperator operator) throws MalformedJsonQueryException {
        switch (operator) {
            case $NEAR: {
                return new PositionQueryLiteral(this.jsonParser.readValueAsObject(nodeField, Position.class));
            }
        }
        return null;
    }

    private QueryLiteral<?> generateArrayQueryLiteral(JsonNode nodeField) throws MalformedJsonQueryException {
        ArrayList list = new ArrayList();
        for (JsonNode aNodeField : nodeField) {
            list.add(this.generatePrimitiveQueryLiteral(aNodeField));
        }
        ListQueryLiteral literal = new ListQueryLiteral();
        literal.setLiteral(list);
        return literal;
    }

    private QueryLiteral<?> generatePrimitiveQueryLiteral(JsonNode nodeField) throws MalformedJsonQueryException {
        QueryLiteral literal;
        if (nodeField.isDouble()) {
            literal = new DoubleQueryLiteral();
            literal.setLiteral(nodeField.asDouble());
        } else if (nodeField.canConvertToLong()) {
            literal = new LongQueryLiteral();
            literal.setLiteral(nodeField.asLong());
        } else if (nodeField.isBoolean()) {
            literal = new BooleanQueryLiteral();
            literal.setLiteral(nodeField.asBoolean());
        } else if (nodeField.isTextual()) {
            String valueString = nodeField.textValue();
            Matcher isoDateMatcher = ISO_DATE_PATTERN.matcher(valueString);
            if (isoDateMatcher.find()) {
                try {
                    literal = new DateQueryLiteral();
                    literal.setLiteral(ISODateTimeFormat.dateTimeParser().parseDateTime(isoDateMatcher.group(1)).toDate());
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedJsonQueryException("Wrong date format", e);
                }
            }
            literal = new StringQueryLiteral();
            Matcher isoPeriodMatcher = PERIOD_PATTERN.matcher(valueString);
            if (isoPeriodMatcher.find()) {
                TemporalAmount temporalAmount;
                try {
                    temporalAmount = Period.parse(isoPeriodMatcher.group(1));
                }
                catch (DateTimeParseException ignored) {
                    temporalAmount = Duration.parse(isoPeriodMatcher.group(1));
                }
                literal.setLiteral(temporalAmount.toString());
            } else {
                literal.setLiteral(valueString);
            }
        } else {
            throw new MalformedJsonQueryException("Unsupported type");
        }
        return literal;
    }
}

