/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.gson.JsonParseException;
import io.corbel.lib.queries.exception.MalformedJsonQueryException;
import io.corbel.lib.queries.parser.CustomJsonParser;
import io.corbel.lib.queries.parser.SortParser;
import io.corbel.lib.queries.request.Sort;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonSortParser
implements SortParser {
    private static final Logger LOG = LoggerFactory.getLogger(JacksonSortParser.class);
    private final CustomJsonParser jsonParser;

    public JacksonSortParser(CustomJsonParser jsonParser) {
        this.jsonParser = jsonParser;
    }

    @Override
    public Sort parse(String json) throws MalformedJsonQueryException {
        try {
            JsonNode parsedJson = this.jsonParser.readValueAsTree(json);
            if (!parsedJson.isObject() || parsedJson.size() != 1) {
                throw new IllegalArgumentException("Sort is only allowed on one field. You gave me " + parsedJson.size());
            }
            Map.Entry entry = (Map.Entry)parsedJson.fields().next();
            String orderType = ((JsonNode)entry.getValue()).asText();
            String field = (String)entry.getKey();
            return new Sort(orderType, field);
        }
        catch (JsonParseException | IllegalStateException | UnsupportedOperationException e) {
            LOG.debug("Invalid sort string: {}. Throwing IllegalArgumentException", (Object)json);
            throw new IllegalArgumentException("Not a valid sort string: " + json);
        }
    }
}

