/*
 * Decompiled with CFR 0.152.
 */
package io.corbel.lib.queries.request;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.corbel.lib.queries.request.AggregationResultsFactory;
import io.corbel.lib.queries.request.HistogramEntry;
import java.util.Optional;

public class JsonAggregationResultsFactory
implements AggregationResultsFactory<JsonElement> {
    private static final String AVERAGE = "average";
    private static final String COUNT = "count";
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final String SUM = "sum";
    private Gson gson = new Gson();

    public JsonAggregationResultsFactory(Gson gson) {
        this.gson = gson;
    }

    public JsonAggregationResultsFactory() {
        this(new Gson());
    }

    @Override
    public JsonObject averageResult(Optional<Double> average) {
        JsonElement value = average.map(JsonPrimitive::new).orElse(null);
        return this.json(new JsonField(AVERAGE, value));
    }

    @Override
    public JsonObject countResult(long count) {
        JsonPrimitive value = new JsonPrimitive((Number)count);
        return this.json(new JsonField(COUNT, (JsonElement)value));
    }

    @Override
    public JsonObject maxResult(Optional<Object> max) {
        JsonElement value = max.map(arg_0 -> ((Gson)this.gson).toJsonTree(arg_0)).orElse(null);
        return this.json(new JsonField(MAX, value));
    }

    @Override
    public JsonObject minResult(Optional<Object> min) {
        JsonElement value = min.map(arg_0 -> ((Gson)this.gson).toJsonTree(arg_0)).orElse(null);
        return this.json(new JsonField(MIN, value));
    }

    @Override
    public JsonObject sumResult(Optional<Double> sum) {
        JsonElement value = sum.map(JsonPrimitive::new).orElse(null);
        return this.json(new JsonField(SUM, value));
    }

    @Override
    public JsonArray histogramResult(HistogramEntry ... entries) {
        return this.gson.toJsonTree((Object)entries).getAsJsonArray();
    }

    private JsonObject json(JsonField ... fields) {
        JsonObject json = new JsonObject();
        for (JsonField field : fields) {
            json.add(field.key, field.value);
        }
        return json;
    }

    private class JsonField {
        final String key;
        final JsonElement value;

        public JsonField(String key, JsonElement value) {
            this.key = key;
            this.value = value;
        }
    }
}

